/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.components.IMarker;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.MPPointF;
import java.lang.ref.WeakReference;

public class MarkerImage
implements IMarker {
    private Context mContext;
    private Drawable mDrawable;
    private MPPointF mOffset = new MPPointF();
    private MPPointF mOffset2 = new MPPointF();
    private WeakReference<Chart> mWeakChart;
    private FSize mSize = new FSize();
    private Rect mDrawableBoundsCache = new Rect();

    public MarkerImage(Context context, int drawableResourceId) {
        this.mContext = context;
        this.mDrawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getResources().getDrawable(drawableResourceId, null) : this.mContext.getResources().getDrawable(drawableResourceId);
    }

    public void setOffset(MPPointF offset) {
        this.mOffset = offset;
        if (this.mOffset == null) {
            this.mOffset = new MPPointF();
        }
    }

    public void setOffset(float offsetX, float offsetY) {
        this.mOffset.x = offsetX;
        this.mOffset.y = offsetY;
    }

    @Override
    public MPPointF getOffset() {
        return this.mOffset;
    }

    public void setSize(FSize size) {
        this.mSize = size;
        if (this.mSize == null) {
            this.mSize = new FSize();
        }
    }

    public FSize getSize() {
        return this.mSize;
    }

    public void setChartView(Chart chart) {
        this.mWeakChart = new WeakReference<Chart>(chart);
    }

    public Chart getChartView() {
        return this.mWeakChart == null ? null : (Chart)this.mWeakChart.get();
    }

    @Override
    public MPPointF getOffsetForDrawingAtPoint(float posX, float posY) {
        MPPointF offset = this.getOffset();
        this.mOffset2.x = offset.x;
        this.mOffset2.y = offset.y;
        Chart chart = this.getChartView();
        float width = this.mSize.width;
        float height = this.mSize.height;
        if (width == 0.0f && this.mDrawable != null) {
            width = this.mDrawable.getIntrinsicWidth();
        }
        if (height == 0.0f && this.mDrawable != null) {
            height = this.mDrawable.getIntrinsicHeight();
        }
        if (posX + this.mOffset2.x < 0.0f) {
            this.mOffset2.x = -posX;
        } else if (chart != null && posX + width + this.mOffset2.x > (float)chart.getWidth()) {
            this.mOffset2.x = (float)chart.getWidth() - posX - width;
        }
        if (posY + this.mOffset2.y < 0.0f) {
            this.mOffset2.y = -posY;
        } else if (chart != null && posY + height + this.mOffset2.y > (float)chart.getHeight()) {
            this.mOffset2.y = (float)chart.getHeight() - posY - height;
        }
        return this.mOffset2;
    }

    @Override
    public void refreshContent(Entry e, Highlight highlight) {
    }

    @Override
    public void draw(Canvas canvas, float posX, float posY) {
        if (this.mDrawable == null) {
            return;
        }
        MPPointF offset = this.getOffsetForDrawingAtPoint(posX, posY);
        float width = this.mSize.width;
        float height = this.mSize.height;
        if (width == 0.0f && this.mDrawable != null) {
            width = this.mDrawable.getIntrinsicWidth();
        }
        if (height == 0.0f && this.mDrawable != null) {
            height = this.mDrawable.getIntrinsicHeight();
        }
        this.mDrawable.copyBounds(this.mDrawableBoundsCache);
        this.mDrawable.setBounds(this.mDrawableBoundsCache.left, this.mDrawableBoundsCache.top, this.mDrawableBoundsCache.left + (int)width, this.mDrawableBoundsCache.top + (int)height);
        int saveId = canvas.save();
        canvas.translate(posX + offset.x, posY + offset.y);
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(saveId);
        this.mDrawable.setBounds(this.mDrawableBoundsCache);
    }
}

