/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;

public class LineBuffer
extends AbstractBuffer<ILineDataSet> {
    public LineBuffer(int size) {
        super(size < 4 ? 4 : size);
    }

    public void moveTo(float x, float y) {
        if (this.index != 0) {
            return;
        }
        this.buffer[this.index++] = x;
        this.buffer[this.index++] = y;
        this.buffer[this.index] = x;
        this.buffer[this.index + 1] = y;
    }

    public void lineTo(float x, float y) {
        if (this.index == 2) {
            this.buffer[this.index++] = x;
            this.buffer[this.index++] = y;
        } else {
            float prevX = this.buffer[this.index - 2];
            float prevY = this.buffer[this.index - 1];
            this.buffer[this.index++] = prevX;
            this.buffer[this.index++] = prevY;
            this.buffer[this.index++] = x;
            this.buffer[this.index++] = y;
        }
    }

    @Override
    public void feed(ILineDataSet data) {
        int from;
        this.moveTo(((Entry)data.getEntryForIndex(this.mFrom)).getXIndex(), ((Entry)data.getEntryForIndex(this.mFrom)).getVal() * this.phaseY);
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        for (int i = from = this.mFrom + 1; i < size; ++i) {
            Object e = data.getEntryForIndex(i);
            this.lineTo(((Entry)e).getXIndex(), ((Entry)e).getVal() * this.phaseY);
        }
        this.reset();
    }
}

