/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Typeface;
import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.utils.ValueFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ChartData<T extends DataSet<? extends Entry>> {
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    protected float mLeftAxisMax = 0.0f;
    protected float mLeftAxisMin = 0.0f;
    protected float mRightAxisMax = 0.0f;
    protected float mRightAxisMin = 0.0f;
    private float mYValueSum = 0.0f;
    private int mYValCount = 0;
    protected int mLastStart = 0;
    protected int mLastEnd = 0;
    private float mXValAverageLength = 0.0f;
    protected List<String> mXVals;
    protected List<T> mDataSets;

    public ChartData() {
        this.mXVals = new ArrayList<String>();
        this.mDataSets = new ArrayList<T>();
    }

    public ChartData(List<String> xVals) {
        this.mXVals = xVals;
        this.mDataSets = new ArrayList<T>();
        this.init();
    }

    public ChartData(String[] xVals) {
        this.mXVals = this.arrayToList(xVals);
        this.mDataSets = new ArrayList<T>();
        this.init();
    }

    public ChartData(List<String> xVals, List<T> sets) {
        this.mXVals = xVals;
        this.mDataSets = sets;
        this.init();
    }

    public ChartData(String[] xVals, List<T> sets) {
        this.mXVals = this.arrayToList(xVals);
        this.mDataSets = sets;
        this.init();
    }

    private List<String> arrayToList(String[] array) {
        return Arrays.asList(array);
    }

    protected void init() {
        this.isLegal();
        this.calcMinMax(this.mLastStart, this.mLastEnd);
        this.calcYValueSum();
        this.calcYValueCount();
        this.calcXValAverageLength();
    }

    private void calcXValAverageLength() {
        if (this.mXVals.size() <= 0) {
            this.mXValAverageLength = 1.0f;
            return;
        }
        float sum = 1.0f;
        for (int i = 0; i < this.mXVals.size(); ++i) {
            sum += (float)this.mXVals.get(i).length();
        }
        this.mXValAverageLength = sum / (float)this.mXVals.size();
    }

    private void isLegal() {
        if (this.mDataSets == null) {
            return;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            if (((DataSet)this.mDataSets.get(i)).getYVals().size() <= this.mXVals.size()) continue;
            throw new IllegalArgumentException("One or more of the DataSet Entry arrays are longer than the x-values array of this ChartData object.");
        }
    }

    public void notifyDataChanged() {
        this.init();
    }

    public void calcMinMax(int start, int end) {
        if (this.mDataSets == null || this.mDataSets.size() < 1) {
            this.mYMax = 0.0f;
            this.mYMin = 0.0f;
        } else {
            T firstRight;
            T firstLeft;
            this.mLastStart = start;
            this.mLastEnd = end;
            this.mYMin = Float.MAX_VALUE;
            this.mYMax = -3.4028235E38f;
            for (int i = 0; i < this.mDataSets.size(); ++i) {
                ((DataSet)this.mDataSets.get(i)).calcMinMax(start, end);
                if (((DataSet)this.mDataSets.get(i)).getYMin() < this.mYMin) {
                    this.mYMin = ((DataSet)this.mDataSets.get(i)).getYMin();
                }
                if (!(((DataSet)this.mDataSets.get(i)).getYMax() > this.mYMax)) continue;
                this.mYMax = ((DataSet)this.mDataSets.get(i)).getYMax();
            }
            if (this.mYMin == Float.MAX_VALUE) {
                this.mYMin = 0.0f;
                this.mYMax = 0.0f;
            }
            if ((firstLeft = this.getFirstLeft()) != null) {
                this.mLeftAxisMax = ((DataSet)firstLeft).getYMax();
                this.mLeftAxisMin = ((DataSet)firstLeft).getYMin();
                for (DataSet dataSet : this.mDataSets) {
                    if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                    if (dataSet.getYMin() < this.mLeftAxisMin) {
                        this.mLeftAxisMin = dataSet.getYMin();
                    }
                    if (!(dataSet.getYMax() > this.mLeftAxisMax)) continue;
                    this.mLeftAxisMax = dataSet.getYMax();
                }
            }
            if ((firstRight = this.getFirstRight()) != null) {
                this.mRightAxisMax = ((DataSet)firstRight).getYMax();
                this.mRightAxisMin = ((DataSet)firstRight).getYMin();
                for (DataSet dataSet : this.mDataSets) {
                    if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                    if (dataSet.getYMin() < this.mRightAxisMin) {
                        this.mRightAxisMin = dataSet.getYMin();
                    }
                    if (!(dataSet.getYMax() > this.mRightAxisMax)) continue;
                    this.mRightAxisMax = dataSet.getYMax();
                }
            }
            this.handleEmptyAxis(firstLeft, firstRight);
        }
    }

    protected void calcYValueSum() {
        this.mYValueSum = 0.0f;
        if (this.mDataSets == null) {
            return;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            this.mYValueSum += Math.abs(((DataSet)this.mDataSets.get(i)).getYValueSum());
        }
    }

    protected void calcYValueCount() {
        this.mYValCount = 0;
        if (this.mDataSets == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            count += ((DataSet)this.mDataSets.get(i)).getEntryCount();
        }
        this.mYValCount = count;
    }

    public int getDataSetCount() {
        if (this.mDataSets == null) {
            return 0;
        }
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMin(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisMin;
        }
        return this.mRightAxisMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getYMax(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisMax;
        }
        return this.mRightAxisMax;
    }

    public float getXValAverageLength() {
        return this.mXValAverageLength;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public int getYValCount() {
        return this.mYValCount;
    }

    public List<String> getXVals() {
        return this.mXVals;
    }

    public void addXValue(String xVal) {
        this.mXValAverageLength = (this.mXValAverageLength + (float)xVal.length()) / 2.0f;
        this.mXVals.add(xVal);
    }

    public void removeXValue(int index) {
        this.mXVals.remove(index);
    }

    public List<T> getDataSets() {
        return this.mDataSets;
    }

    protected int getDataSetIndexByLabel(List<T> dataSets, String label, boolean ignorecase) {
        if (ignorecase) {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equalsIgnoreCase(((DataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        } else {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equals(((DataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        }
        return -1;
    }

    public int getXValCount() {
        return this.mXVals.size();
    }

    protected String[] getDataSetLabels() {
        String[] types = new String[this.mDataSets.size()];
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            types[i] = ((DataSet)this.mDataSets.get(i)).getLabel();
        }
        return types;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        return ((DataSet)this.mDataSets.get(highlight.getDataSetIndex())).getEntryForXIndex(highlight.getXIndex());
    }

    public T getDataSetByLabel(String label, boolean ignorecase) {
        int index = this.getDataSetIndexByLabel(this.mDataSets, label, ignorecase);
        if (index < 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((DataSet)this.mDataSets.get(index));
    }

    public T getDataSetByIndex(int index) {
        if (this.mDataSets == null || index < 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((DataSet)this.mDataSets.get(index));
    }

    public void addDataSet(T d) {
        if (d == null) {
            return;
        }
        this.mYValCount += ((DataSet)d).getEntryCount();
        this.mYValueSum += ((DataSet)d).getYValueSum();
        if (this.mDataSets.size() <= 0) {
            this.mYMax = ((DataSet)d).getYMax();
            this.mYMin = ((DataSet)d).getYMin();
            if (((DataSet)d).getAxisDependency() == YAxis.AxisDependency.LEFT) {
                this.mLeftAxisMax = ((DataSet)d).getYMax();
                this.mLeftAxisMin = ((DataSet)d).getYMin();
            } else {
                this.mRightAxisMax = ((DataSet)d).getYMax();
                this.mRightAxisMin = ((DataSet)d).getYMin();
            }
        } else {
            if (this.mYMax < ((DataSet)d).getYMax()) {
                this.mYMax = ((DataSet)d).getYMax();
            }
            if (this.mYMin > ((DataSet)d).getYMin()) {
                this.mYMin = ((DataSet)d).getYMin();
            }
            if (((DataSet)d).getAxisDependency() == YAxis.AxisDependency.LEFT) {
                if (this.mLeftAxisMax < ((DataSet)d).getYMax()) {
                    this.mLeftAxisMax = ((DataSet)d).getYMax();
                }
                if (this.mLeftAxisMin > ((DataSet)d).getYMin()) {
                    this.mLeftAxisMin = ((DataSet)d).getYMin();
                }
            } else {
                if (this.mRightAxisMax < ((DataSet)d).getYMax()) {
                    this.mRightAxisMax = ((DataSet)d).getYMax();
                }
                if (this.mRightAxisMin > ((DataSet)d).getYMin()) {
                    this.mRightAxisMin = ((DataSet)d).getYMin();
                }
            }
        }
        this.mDataSets.add(d);
        this.handleEmptyAxis(this.getFirstLeft(), this.getFirstRight());
    }

    private void handleEmptyAxis(T firstLeft, T firstRight) {
        if (firstLeft == null) {
            this.mLeftAxisMax = this.mRightAxisMax;
            this.mLeftAxisMin = this.mRightAxisMin;
        } else if (firstRight == null) {
            this.mRightAxisMax = this.mLeftAxisMax;
            this.mRightAxisMin = this.mLeftAxisMin;
        }
    }

    public boolean removeDataSet(T d) {
        if (d == null) {
            return false;
        }
        boolean removed = this.mDataSets.remove(d);
        if (removed) {
            this.mYValCount -= ((DataSet)d).getEntryCount();
            this.mYValueSum -= ((DataSet)d).getYValueSum();
            this.calcMinMax(this.mLastStart, this.mLastEnd);
        }
        return removed;
    }

    public boolean removeDataSet(int index) {
        if (index >= this.mDataSets.size() || index < 0) {
            return false;
        }
        DataSet set = (DataSet)this.mDataSets.get(index);
        return this.removeDataSet(set);
    }

    public void addEntry(Entry e, int dataSetIndex) {
        if (this.mDataSets.size() > dataSetIndex && dataSetIndex >= 0) {
            float val = e.getVal();
            DataSet set = (DataSet)this.mDataSets.get(dataSetIndex);
            if (this.mYValCount == 0) {
                this.mYMin = val;
                this.mYMax = val;
                if (set.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                    this.mLeftAxisMax = e.getVal();
                    this.mLeftAxisMin = e.getVal();
                } else {
                    this.mRightAxisMax = e.getVal();
                    this.mRightAxisMin = e.getVal();
                }
            } else {
                if (this.mYMax < val) {
                    this.mYMax = val;
                }
                if (this.mYMin > val) {
                    this.mYMin = val;
                }
                if (set.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                    if (this.mLeftAxisMax < e.getVal()) {
                        this.mLeftAxisMax = e.getVal();
                    }
                    if (this.mLeftAxisMin > e.getVal()) {
                        this.mLeftAxisMin = e.getVal();
                    }
                } else {
                    if (this.mRightAxisMax < e.getVal()) {
                        this.mRightAxisMax = e.getVal();
                    }
                    if (this.mRightAxisMin > e.getVal()) {
                        this.mRightAxisMin = e.getVal();
                    }
                }
            }
            ++this.mYValCount;
            this.mYValueSum += val;
            this.handleEmptyAxis(this.getFirstLeft(), this.getFirstRight());
            set.addEntry(e);
        } else {
            Log.e((String)"addEntry", (String)"Cannot add Entry because dataSetIndex too high or too low.");
        }
    }

    public boolean removeEntry(Entry e, int dataSetIndex) {
        if (e == null || dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        boolean removed = ((DataSet)this.mDataSets.get(dataSetIndex)).removeEntry(e.getXIndex());
        if (removed) {
            float val = e.getVal();
            --this.mYValCount;
            this.mYValueSum -= val;
            this.calcMinMax(this.mLastStart, this.mLastEnd);
        }
        return removed;
    }

    public boolean removeEntry(int xIndex, int dataSetIndex) {
        if (dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        DataSet dataSet = (DataSet)this.mDataSets.get(dataSetIndex);
        Object e = dataSet.getEntryForXIndex(xIndex);
        if (e == null || ((Entry)e).getXIndex() != xIndex) {
            return false;
        }
        return this.removeEntry((Entry)e, dataSetIndex);
    }

    public T getDataSetForEntry(Entry e) {
        if (e == null) {
            return null;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            DataSet set = (DataSet)this.mDataSets.get(i);
            for (int j = 0; j < set.getEntryCount(); ++j) {
                if (!e.equalTo((Entry)set.getEntryForXIndex(e.getXIndex()))) continue;
                return (T)set;
            }
        }
        return null;
    }

    public int[] getColors() {
        if (this.mDataSets == null) {
            return null;
        }
        int clrcnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            clrcnt += ((DataSet)this.mDataSets.get(i)).getColors().size();
        }
        int[] colors = new int[clrcnt];
        int cnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            List<Integer> clrs = ((DataSet)this.mDataSets.get(i)).getColors();
            for (Integer clr : clrs) {
                colors[cnt] = clr;
                ++cnt;
            }
        }
        return colors;
    }

    public int getIndexOfDataSet(T dataSet) {
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            if (this.mDataSets.get(i) != dataSet) continue;
            return i;
        }
        return -1;
    }

    public T getFirstLeft() {
        for (DataSet dataSet : this.mDataSets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public T getFirstRight() {
        for (DataSet dataSet : this.mDataSets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public static List<String> generateXVals(int from, int to) {
        ArrayList<String> xvals = new ArrayList<String>();
        for (int i = from; i < to; ++i) {
            xvals.add("" + i);
        }
        return xvals;
    }

    public void setValueFormatter(ValueFormatter f) {
        if (f == null) {
            return;
        }
        for (DataSet set : this.mDataSets) {
            set.setValueFormatter(f);
        }
    }

    public void setValueTextColor(int color) {
        for (DataSet set : this.mDataSets) {
            set.setValueTextColor(color);
        }
    }

    public void setValueTypeface(Typeface tf) {
        for (DataSet set : this.mDataSets) {
            set.setValueTypeface(tf);
        }
    }

    public void setValueTextSize(float size) {
        for (DataSet set : this.mDataSets) {
            set.setValueTextSize(size);
        }
    }

    public void setDrawValues(boolean enabled) {
        for (DataSet set : this.mDataSets) {
            set.setDrawValues(enabled);
        }
    }

    public void setHighlightEnabled(boolean enabled) {
        for (DataSet set : this.mDataSets) {
            set.setHighlightEnabled(enabled);
        }
    }

    public boolean isHighlightEnabled() {
        for (DataSet set : this.mDataSets) {
            if (set.isHighlightEnabled()) continue;
            return false;
        }
        return true;
    }

    public void clearValues() {
        this.mDataSets.clear();
        this.notifyDataChanged();
    }

    public boolean contains(Entry e) {
        for (DataSet set : this.mDataSets) {
            if (!set.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(T dataSet) {
        for (DataSet set : this.mDataSets) {
            if (!set.equals(dataSet)) continue;
            return true;
        }
        return false;
    }
}

