/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;

public class BarChart
extends BarLineChartBase<BarData>
implements BarDataProvider {
    private boolean mDrawHighlightArrow = false;
    private boolean mDrawValueAboveBar = true;
    private boolean mDrawBarShadow = false;

    public BarChart(Context context) {
        super(context);
    }

    public BarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new BarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mXAxisRenderer = new XAxisRendererBarChart(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer, this);
        this.mHighlighter = new BarHighlighter(this);
        this.mXChartMin = -0.5f;
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        this.mDeltaX += 0.5f;
        this.mDeltaX *= (float)((BarData)this.mData).getDataSetCount();
        int maxEntry = 0;
        for (int i = 0; i < ((BarData)this.mData).getDataSetCount(); ++i) {
            Object set = ((BarData)this.mData).getDataSetByIndex(i);
            if (maxEntry >= ((DataSet)set).getEntryCount()) continue;
            maxEntry = ((DataSet)set).getEntryCount();
        }
        float groupSpace = ((BarData)this.mData).getGroupSpace();
        this.mDeltaX += (float)maxEntry * groupSpace;
        this.mXChartMax = this.mDeltaX - this.mXChartMin;
    }

    @Override
    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.mDataNotSet || this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.mHighlighter.getHighlight(x, y);
    }

    public RectF getBarBounds(BarEntry e) {
        BarDataSet set = (BarDataSet)((BarData)this.mData).getDataSetForEntry(e);
        if (set == null) {
            return null;
        }
        float barspace = set.getBarSpace();
        float y = e.getVal();
        float x = e.getXIndex();
        float barWidth = 0.5f;
        float spaceHalf = barspace / 2.0f;
        float left = x - barWidth + spaceHalf;
        float right = x + barWidth - spaceHalf;
        float top = y >= 0.0f ? y : 0.0f;
        float bottom = y <= 0.0f ? y : 0.0f;
        RectF bounds = new RectF(left, top, right, bottom);
        this.getTransformer(set.getAxisDependency()).rectValueToPixel(bounds);
        return bounds;
    }

    public void setDrawHighlightArrow(boolean enabled) {
        this.mDrawHighlightArrow = enabled;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return this.mDrawHighlightArrow;
    }

    public void setDrawValueAboveBar(boolean enabled) {
        this.mDrawValueAboveBar = enabled;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    public void setDrawBarShadow(boolean enabled) {
        this.mDrawBarShadow = enabled;
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    public BarData getBarData() {
        return (BarData)this.mData;
    }

    @Override
    public int getLowestVisibleXIndex() {
        float step = ((BarData)this.mData).getDataSetCount();
        float div = step <= 1.0f ? 1.0f : step + ((BarData)this.mData).getGroupSpace();
        float[] pts = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return (int)(pts[0] <= this.getXChartMin() ? 0.0f : pts[0] / div + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float step = ((BarData)this.mData).getDataSetCount();
        float div = step <= 1.0f ? 1.0f : step + ((BarData)this.mData).getGroupSpace();
        float[] pts = new float[]{this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return (int)(pts[0] >= this.getXChartMax() ? this.getXChartMax() / div : pts[0] / div);
    }
}

