/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.CircleBuffer;
import com.github.mikephil.charting.buffer.LineBuffer;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.LineDataProvider;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class LineChartRenderer
extends LineScatterCandleRadarRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    protected Bitmap mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Path cubicPath = new Path();
    protected Path cubicFillPath = new Path();
    protected LineBuffer[] mLineBuffers;
    protected CircleBuffer[] mCircleBuffers;

    public LineChartRenderer(LineDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void initBuffers() {
        LineData lineData = this.mChart.getLineData();
        this.mLineBuffers = new LineBuffer[lineData.getDataSetCount()];
        this.mCircleBuffers = new CircleBuffer[lineData.getDataSetCount()];
        for (int i = 0; i < this.mLineBuffers.length; ++i) {
            LineDataSet set = (LineDataSet)lineData.getDataSetByIndex(i);
            this.mLineBuffers[i] = new LineBuffer(set.getEntryCount() * 4 - 4);
            this.mCircleBuffers[i] = new CircleBuffer(set.getEntryCount() * 2);
        }
    }

    @Override
    public void drawData(Canvas c) {
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || this.mDrawBitmap.getWidth() != width || this.mDrawBitmap.getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.mBitmapCanvas = new Canvas(this.mDrawBitmap);
            } else {
                return;
            }
        }
        this.mDrawBitmap.eraseColor(0);
        LineData lineData = this.mChart.getLineData();
        for (LineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
        c.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void drawDataSet(Canvas c, LineDataSet dataSet) {
        List<Entry> entries = dataSet.getYVals();
        if (entries.size() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
        if (dataSet.isDrawCubicEnabled()) {
            this.drawCubic(c, dataSet, entries);
        } else {
            this.drawLinear(c, dataSet, entries);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubic(Canvas c, LineDataSet dataSet, List<Entry> entries) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
        Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
        int minx = Math.max(dataSet.getEntryPosition((Entry)entryFrom), 0);
        int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, entries.size());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        int size = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx);
        if (size - minx >= 2) {
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            Entry prevPrev = entries.get(minx);
            Entry prev = entries.get(minx);
            Entry cur = entries.get(minx);
            Entry next = entries.get(minx + 1);
            this.cubicPath.moveTo((float)cur.getXIndex(), cur.getVal() * phaseY);
            prevDx = (float)(cur.getXIndex() - prev.getXIndex()) * intensity;
            prevDy = (cur.getVal() - prev.getVal()) * intensity;
            curDx = (float)(next.getXIndex() - cur.getXIndex()) * intensity;
            curDy = (next.getVal() - cur.getVal()) * intensity;
            this.cubicPath.cubicTo((float)prev.getXIndex() + prevDx, (prev.getVal() + prevDy) * phaseY, (float)cur.getXIndex() - curDx, (cur.getVal() - curDy) * phaseY, (float)cur.getXIndex(), cur.getVal() * phaseY);
            int count = Math.min(size, entries.size() - 1);
            for (int j = minx + 1; j < count; ++j) {
                prevPrev = entries.get(j == 1 ? 0 : j - 2);
                prev = entries.get(j - 1);
                cur = entries.get(j);
                next = entries.get(j + 1);
                prevDx = (float)(cur.getXIndex() - prevPrev.getXIndex()) * intensity;
                prevDy = (cur.getVal() - prevPrev.getVal()) * intensity;
                curDx = (float)(next.getXIndex() - prev.getXIndex()) * intensity;
                curDy = (next.getVal() - prev.getVal()) * intensity;
                this.cubicPath.cubicTo((float)prev.getXIndex() + prevDx, (prev.getVal() + prevDy) * phaseY, (float)cur.getXIndex() - curDx, (cur.getVal() - curDy) * phaseY, (float)cur.getXIndex(), cur.getVal() * phaseY);
            }
            if (size > entries.size() - 1) {
                prevPrev = entries.get(entries.size() >= 3 ? entries.size() - 3 : entries.size() - 2);
                prev = entries.get(entries.size() - 2);
                next = cur = entries.get(entries.size() - 1);
                prevDx = (float)(cur.getXIndex() - prevPrev.getXIndex()) * intensity;
                prevDy = (cur.getVal() - prevPrev.getVal()) * intensity;
                curDx = (float)(next.getXIndex() - prev.getXIndex()) * intensity;
                curDy = (next.getVal() - prev.getVal()) * intensity;
                this.cubicPath.cubicTo((float)prev.getXIndex() + prevDx, (prev.getVal() + prevDy) * phaseY, (float)cur.getXIndex() - curDx, (cur.getVal() - curDy) * phaseY, (float)cur.getXIndex(), cur.getVal() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(dataSet, this.cubicFillPath, trans, ((Entry)entryFrom).getXIndex(), ((Entry)entryFrom).getXIndex() + size);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(LineDataSet dataSet, Path spline, Transformer trans, int from, int to) {
        float fillMin = this.mChart.getFillFormatter().getFillLinePosition(dataSet, this.mChart.getLineData(), this.mChart.getYChartMax(), this.mChart.getYChartMin());
        spline.lineTo((float)(to - 1), fillMin);
        spline.lineTo((float)from, fillMin);
        spline.close();
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mRenderPaint.setColor(dataSet.getFillColor());
        this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
        trans.pathValueToPixel(spline);
        this.mBitmapCanvas.drawPath(spline, this.mRenderPaint);
        this.mRenderPaint.setAlpha(255);
    }

    protected void drawLinear(Canvas c, LineDataSet dataSet, List<Entry> entries) {
        int dataSetIndex = this.mChart.getLineData().getIndexOfDataSet(dataSet);
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Canvas canvas = null;
        canvas = dataSet.isDashedLineEnabled() ? this.mBitmapCanvas : c;
        Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
        Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
        int minx = Math.max(dataSet.getEntryPosition((Entry)entryFrom), 0);
        int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, entries.size());
        int range = (maxx - minx) * 4 - 4;
        LineBuffer buffer = this.mLineBuffers[dataSetIndex];
        buffer.setPhases(phaseX, phaseY);
        buffer.limitFrom(minx);
        buffer.limitTo(maxx);
        buffer.feed(entries);
        trans.pointValuesToPixel(buffer.buffer);
        if (dataSet.getColors().size() > 1) {
            for (int j = 0; j < range && this.mViewPortHandler.isInBoundsRight(buffer.buffer[j]); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2]) || !this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 1]) && !this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 3]) || !this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 1]) && !this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 3])) continue;
                this.mRenderPaint.setColor(dataSet.getColor(j / 4 + minx));
                canvas.drawLine(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            canvas.drawLines(buffer.buffer, 0, range, this.mRenderPaint);
        }
        this.mRenderPaint.setPathEffect(null);
        if (dataSet.isDrawFilledEnabled() && entries.size() > 0) {
            this.drawLinearFill(c, dataSet, entries, minx, maxx, trans);
        }
    }

    protected void drawLinearFill(Canvas c, LineDataSet dataSet, List<Entry> entries, int minx, int maxx, Transformer trans) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mRenderPaint.setColor(dataSet.getFillColor());
        this.mRenderPaint.setAlpha(dataSet.getFillAlpha());
        Path filled = this.generateFilledPath(entries, this.mChart.getFillFormatter().getFillLinePosition(dataSet, this.mChart.getLineData(), this.mChart.getYChartMax(), this.mChart.getYChartMin()), minx, maxx);
        trans.pathValueToPixel(filled);
        c.drawPath(filled, this.mRenderPaint);
        this.mRenderPaint.setAlpha(255);
    }

    private Path generateFilledPath(List<Entry> entries, float fillMin, int from, int to) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        Path filled = new Path();
        filled.moveTo((float)entries.get(from).getXIndex(), fillMin);
        filled.lineTo((float)entries.get(from).getXIndex(), entries.get(from).getVal() * phaseY);
        int count = (int)Math.ceil((float)(to - from) * phaseX + (float)from);
        for (int x = from + 1; x < count; ++x) {
            Entry e = entries.get(x);
            filled.lineTo((float)e.getXIndex(), e.getVal() * phaseY);
        }
        filled.lineTo((float)entries.get(Math.max(Math.min((int)Math.ceil((float)(to - from) * phaseX + (float)from) - 1, entries.size() - 1), 0)).getXIndex(), fillMin);
        filled.close();
        return filled;
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getLineData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List dataSets = this.mChart.getLineData().getDataSets();
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                LineDataSet dataSet = (LineDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleSize() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                List entries = dataSet.getYVals();
                Object entryFrom = dataSet.getEntryForXIndex(this.mMinX);
                Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
                int minx = Math.max(dataSet.getEntryPosition((Entry)entryFrom), 0);
                int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, entries.size());
                float[] positions = trans.generateTransformedValuesLine(entries, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), minx, maxx);
                for (int j = 0; j < positions.length; j += 2) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    float val = ((Entry)entries.get(j / 2 + minx)).getVal();
                    c.drawText(dataSet.getValueFormatter().getFormattedValue(val), x, y - (float)valOffset, this.mValuePaint);
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawCircles(c);
    }

    protected void drawCircles(Canvas c) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List dataSets = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < dataSets.size(); ++i) {
            LineDataSet dataSet = (LineDataSet)dataSets.get(i);
            if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled()) continue;
            this.mCirclePaintInner.setColor(dataSet.getCircleHoleColor());
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            List<Entry> entries = dataSet.getYVals();
            Object entryFrom = dataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX);
            Object entryTo = dataSet.getEntryForXIndex(this.mMaxX);
            int minx = Math.max(dataSet.getEntryPosition((Entry)entryFrom), 0);
            int maxx = Math.min(dataSet.getEntryPosition((Entry)entryTo) + 1, entries.size());
            CircleBuffer buffer = this.mCircleBuffers[i];
            buffer.setPhases(phaseX, phaseY);
            buffer.limitFrom(minx);
            buffer.limitTo(maxx);
            buffer.feed(entries);
            trans.pointValuesToPixel(buffer.buffer);
            float halfsize = dataSet.getCircleSize() / 2.0f;
            int count = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx) * 2;
            for (int j = 0; j < count; j += 2) {
                float x = buffer.buffer[j];
                float y = buffer.buffer[j + 1];
                if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                int circleColor = dataSet.getCircleColor(j / 2 + minx);
                this.mRenderPaint.setColor(circleColor);
                c.drawCircle(x, y, dataSet.getCircleSize(), this.mRenderPaint);
                if (!dataSet.isDrawCircleHoleEnabled() || circleColor == this.mCirclePaintInner.getColor()) continue;
                c.drawCircle(x, y, halfsize, this.mCirclePaintInner);
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            float yVal;
            LineDataSet set = (LineDataSet)this.mChart.getLineData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null || !set.isHighlightEnabled()) continue;
            this.mHighlightPaint.setColor(set.getHighLightColor());
            this.mHighlightPaint.setStrokeWidth(set.getHighlightLineWidth());
            int xIndex = indices[i].getXIndex();
            if ((float)xIndex > this.mChart.getXChartMax() * this.mAnimator.getPhaseX() || (yVal = set.getYValForXIndex(xIndex)) == Float.NaN) continue;
            float y = yVal * this.mAnimator.getPhaseY();
            float[] pts = new float[]{xIndex, this.mChart.getYChartMax(), xIndex, this.mChart.getYChartMin(), this.mChart.getXChartMin(), y, this.mChart.getXChartMax(), y};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
            this.drawHighlightLines(c, pts, set.isHorizontalHighlightIndicatorEnabled(), set.isVerticalHighlightIndicatorEnabled());
        }
    }
}

