/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.DefaultValueFormatter;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry> {
    protected List<Integer> mColors = null;
    protected List<T> mYVals = null;
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    protected int mLastStart = 0;
    protected int mLastEnd = 0;
    private String mLabel = "DataSet";
    private boolean mVisible = true;
    protected boolean mDrawValues = true;
    private int mValueColor = -16777216;
    private float mValueTextSize = 17.0f;
    private Typeface mValueTypeface;
    protected ValueFormatter mValueFormatter;
    protected YAxis.AxisDependency mAxisDependency = YAxis.AxisDependency.LEFT;
    protected boolean mHighlightEnabled = true;

    public DataSet(List<T> yVals, String label) {
        this.mLabel = label;
        this.mYVals = yVals;
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        this.mColors = new ArrayList<Integer>();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.calcMinMax(this.mLastStart, this.mLastEnd);
        this.calcYValueSum();
    }

    public void notifyDataSetChanged() {
        this.calcMinMax(this.mLastStart, this.mLastEnd);
        this.calcYValueSum();
    }

    protected void calcMinMax(int start, int end) {
        int yValCount = this.mYVals.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mLastStart = start;
        this.mLastEnd = endValue;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue && i < this.mYVals.size(); ++i) {
            Entry e = (Entry)this.mYVals.get(i);
            if (e == null || Float.isNaN(e.getVal())) continue;
            if (e.getVal() < this.mYMin) {
                this.mYMin = e.getVal();
            }
            if (!(e.getVal() > this.mYMax)) continue;
            this.mYMax = e.getVal();
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    private void calcYValueSum() {
        this.mYValueSum = 0.0f;
        for (int i = 0; i < this.mYVals.size(); ++i) {
            Entry e = (Entry)this.mYVals.get(i);
            if (e == null) continue;
            this.mYValueSum += Math.abs(e.getVal());
        }
    }

    public int getEntryCount() {
        return this.mYVals.size();
    }

    public float getYValForXIndex(int xIndex) {
        T e = this.getEntryForXIndex(xIndex);
        if (e != null && ((Entry)e).getXIndex() == xIndex) {
            return ((Entry)e).getVal();
        }
        return Float.NaN;
    }

    public T getEntryForXIndex(int x) {
        int index = this.getEntryIndex(x);
        if (index > -1) {
            return (T)((Entry)this.mYVals.get(index));
        }
        return null;
    }

    public int getEntryIndex(int x) {
        int low = 0;
        int high = this.mYVals.size() - 1;
        int closest = -1;
        while (low <= high) {
            int m = (high + low) / 2;
            if (x == ((Entry)this.mYVals.get(m)).getXIndex()) {
                while (m > 0 && ((Entry)this.mYVals.get(m - 1)).getXIndex() == x) {
                    --m;
                }
                return m;
            }
            if (x > ((Entry)this.mYVals.get(m)).getXIndex()) {
                low = m + 1;
            } else {
                high = m - 1;
            }
            closest = m;
        }
        return closest;
    }

    public List<T> getEntriesForXIndex(int x) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int low = 0;
        int high = this.mYVals.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            Entry entry = (Entry)this.mYVals.get(m);
            if (x == entry.getXIndex()) {
                while (m > 0 && ((Entry)this.mYVals.get(m - 1)).getXIndex() == x) {
                    --m;
                }
                high = this.mYVals.size();
                while (m < high && (entry = (Entry)this.mYVals.get(m)).getXIndex() == x) {
                    entries.add(entry);
                    ++m;
                }
            }
            if (x > entry.getXIndex()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    public List<T> getYVals() {
        return this.mYVals;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public int getValueCount() {
        return this.mYVals.size();
    }

    public int getIndexInEntries(int xIndex) {
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (xIndex != ((Entry)this.mYVals.get(i)).getXIndex()) continue;
            return i;
        }
        return -1;
    }

    public abstract DataSet<T> copy();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        for (int i = 0; i < this.mYVals.size(); ++i) {
            buffer.append(((Entry)this.mYVals.get(i)).toString() + " ");
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + (this.mLabel == null ? "" : this.mLabel) + ", entries: " + this.mYVals.size() + "\n");
        return buffer.toString();
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public YAxis.AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    public void setAxisDependency(YAxis.AxisDependency dependency) {
        this.mAxisDependency = dependency;
    }

    public void setDrawValues(boolean enabled) {
        this.mDrawValues = enabled;
    }

    public boolean isDrawValuesEnabled() {
        return this.mDrawValues;
    }

    public void addEntry(Entry e) {
        if (e == null) {
            return;
        }
        float val = e.getVal();
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        if (this.mYVals.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        this.mYValueSum += val;
        this.mYVals.add(e);
    }

    public void addEntryOrdered(Entry e) {
        if (e == null) {
            return;
        }
        float val = e.getVal();
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        if (this.mYVals.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        this.mYValueSum += val;
        if (this.mYVals.size() > 0 && ((Entry)this.mYVals.get(this.mYVals.size() - 1)).getXIndex() > e.getXIndex()) {
            int closestIndex = this.getEntryIndex(e.getXIndex());
            if (((Entry)this.mYVals.get(closestIndex)).getXIndex() < e.getXIndex()) {
                ++closestIndex;
            }
            this.mYVals.add(closestIndex, e);
            return;
        }
        this.mYVals.add(e);
    }

    public boolean removeEntry(T e) {
        if (e == null) {
            return false;
        }
        boolean removed = this.mYVals.remove(e);
        if (removed) {
            float val = ((Entry)e).getVal();
            this.mYValueSum -= val;
            this.calcMinMax(this.mLastStart, this.mLastEnd);
        }
        return removed;
    }

    public boolean removeEntry(int xIndex) {
        T e = this.getEntryForXIndex(xIndex);
        return this.removeEntry(e);
    }

    public void setColors(List<Integer> colors) {
        this.mColors = colors;
    }

    public void setColors(int[] colors) {
        this.mColors = ColorTemplate.createColors(colors);
    }

    public void setColors(int[] colors, Context c) {
        ArrayList<Integer> clrs = new ArrayList<Integer>();
        for (int color : colors) {
            clrs.add(c.getResources().getColor(color));
        }
        this.mColors = clrs;
    }

    public void addColor(int color) {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.add(color);
    }

    public void setColor(int color) {
        this.resetColors();
        this.mColors.add(color);
    }

    public List<Integer> getColors() {
        return this.mColors;
    }

    public int getColor(int index) {
        return this.mColors.get(index % this.mColors.size());
    }

    public int getColor() {
        return this.mColors.get(0);
    }

    public void resetColors() {
        this.mColors = new ArrayList<Integer>();
    }

    public void setHighlightEnabled(boolean enabled) {
        this.mHighlightEnabled = enabled;
    }

    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    public int getEntryPosition(Entry e) {
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (!e.equalTo((Entry)this.mYVals.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void setValueFormatter(ValueFormatter f) {
        if (f == null) {
            return;
        }
        this.mValueFormatter = f;
    }

    public ValueFormatter getValueFormatter() {
        if (this.mValueFormatter == null) {
            return new DefaultValueFormatter(1);
        }
        return this.mValueFormatter;
    }

    public boolean needsDefaultFormatter() {
        if (this.mValueFormatter == null) {
            return true;
        }
        return this.mValueFormatter instanceof DefaultValueFormatter;
    }

    public void setValueTextColor(int color) {
        this.mValueColor = color;
    }

    public int getValueTextColor() {
        return this.mValueColor;
    }

    public void setValueTypeface(Typeface tf) {
        this.mValueTypeface = tf;
    }

    public Typeface getValueTypeface() {
        return this.mValueTypeface;
    }

    public void setValueTextSize(float size) {
        this.mValueTextSize = Utils.convertDpToPixel(size);
    }

    public float getValueTextSize() {
        return this.mValueTextSize;
    }

    public boolean contains(Entry e) {
        for (Entry entry : this.mYVals) {
            if (!entry.equals(e)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mYVals.clear();
        this.mLastStart = 0;
        this.mLastEnd = 0;
        this.notifyDataSetChanged();
    }
}

