/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRendererRadarChart
extends YAxisRenderer {
    private RadarChart mChart;

    public YAxisRendererRadarChart(ViewPortHandler viewPortHandler, YAxis yAxis, RadarChart chart) {
        super(viewPortHandler, yAxis, null);
        this.mChart = chart;
    }

    @Override
    public void computeAxis(float yMin, float yMax) {
        this.computeAxisValues(yMin, yMax);
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        double intervalMagnitude;
        float yMin = min;
        float yMax = max;
        int labelCount = this.mYAxis.getLabelCount();
        double range = Math.abs(yMax - yMin);
        if (labelCount == 0 || range <= 0.0) {
            this.mYAxis.mEntries = new float[0];
            this.mYAxis.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        if (this.mYAxis.isShowOnlyMinMaxEnabled()) {
            this.mYAxis.mEntryCount = 2;
            this.mYAxis.mEntries = new float[2];
            this.mYAxis.mEntries[0] = yMin;
            this.mYAxis.mEntries[1] = yMax;
        } else {
            double f;
            double first = Math.ceil((double)yMin / interval) * interval;
            if (first == 0.0) {
                first = 0.0;
            }
            double last = Utils.nextUp(Math.floor((double)yMax / interval) * interval);
            int n = 0;
            for (f = first; f <= last; f += interval) {
                ++n;
            }
            if (Float.isNaN(this.mYAxis.getAxisMaxValue())) {
                ++n;
            }
            this.mYAxis.mEntryCount = n;
            if (this.mYAxis.mEntries.length < n) {
                this.mYAxis.mEntries = new float[n];
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                this.mYAxis.mEntries[i] = (float)f;
                f += interval;
            }
        }
        this.mYAxis.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
        this.mYAxis.mAxisMaximum = this.mYAxis.mEntries[this.mYAxis.mEntryCount - 1];
        this.mYAxis.mAxisRange = Math.abs(this.mYAxis.mAxisMaximum - this.mYAxis.mAxisMinimum);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        PointF center = this.mChart.getCenterOffsets();
        float factor = this.mChart.getFactor();
        int labelCount = this.mYAxis.mEntryCount;
        for (int j = 0; j < labelCount && (j != labelCount - 1 || this.mYAxis.isDrawTopYLabelEntryEnabled()); ++j) {
            float r = (this.mYAxis.mEntries[j] - this.mYAxis.mAxisMinimum) * factor;
            PointF p = Utils.getPosition(center, r, this.mChart.getRotationAngle());
            String label = this.mYAxis.getFormattedLabel(j);
            c.drawText(label, p.x + 10.0f, p.y, this.mAxisLabelPaint);
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mYAxis.getLimitLines();
        if (limitLines == null) {
            return;
        }
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            float r = (l.getLimit() - this.mChart.getYChartMin()) * factor;
            Path limitPath = new Path();
            for (int j = 0; j < ((RadarData)this.mChart.getData()).getXValCount(); ++j) {
                PointF p = Utils.getPosition(center, r, sliceangle * (float)j + this.mChart.getRotationAngle());
                if (j == 0) {
                    limitPath.moveTo(p.x, p.y);
                    continue;
                }
                limitPath.lineTo(p.x, p.y);
            }
            limitPath.close();
            c.drawPath(limitPath, this.mLimitLinePaint);
        }
    }
}

