/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class PieChartRenderer
extends DataRenderer {
    protected PieChart mChart;
    protected Paint mHolePaint;
    protected Paint mTransparentCirclePaint;
    private TextPaint mCenterTextPaint;
    private StaticLayout mCenterTextLayout;
    private String mCenterTextLastValue;
    private RectF mCenterTextLastBounds = new RectF();
    private RectF[] mRectBuffer = new RectF[]{new RectF(), new RectF(), new RectF()};
    protected Bitmap mDrawBitmap;
    protected Canvas mBitmapCanvas;

    public PieChartRenderer(PieChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mHolePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint = new Paint(1);
        this.mTransparentCirclePaint.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
        this.mCenterTextPaint = new TextPaint(1);
        this.mCenterTextPaint.setColor(-16777216);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mCenterTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
    }

    public Paint getPaintHole() {
        return this.mHolePaint;
    }

    public Paint getPaintTransparentCircle() {
        return this.mTransparentCirclePaint;
    }

    public TextPaint getPaintCenterText() {
        return this.mCenterTextPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || this.mDrawBitmap.getWidth() != width || this.mDrawBitmap.getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.mBitmapCanvas = new Canvas(this.mDrawBitmap);
            } else {
                return;
            }
        }
        this.mDrawBitmap.eraseColor(0);
        PieData pieData = (PieData)this.mChart.getData();
        for (PieDataSet set : pieData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, PieDataSet dataSet) {
        float angle = this.mChart.getRotationAngle();
        List entries = dataSet.getYVals();
        float[] drawAngles = this.mChart.getDrawAngles();
        for (int j = 0; j < entries.size(); ++j) {
            float newangle = drawAngles[j];
            float sliceSpace = dataSet.getSliceSpace();
            Entry e = (Entry)entries.get(j);
            if ((double)Math.abs(e.getVal()) > 1.0E-6 && !this.mChart.needsHighlight(e.getXIndex(), ((PieData)this.mChart.getData()).getIndexOfDataSet(dataSet))) {
                this.mRenderPaint.setColor(dataSet.getColor(j));
                this.mBitmapCanvas.drawArc(this.mChart.getCircleBox(), (angle + sliceSpace / 2.0f) * this.mAnimator.getPhaseY(), (newangle - sliceSpace / 2.0f) * this.mAnimator.getPhaseY(), true, this.mRenderPaint);
            }
            angle += newangle * this.mAnimator.getPhaseX();
        }
    }

    @Override
    public void drawValues(Canvas c) {
        PointF center = this.mChart.getCenterCircleBox();
        float r = this.mChart.getRadius();
        float rotationAngle = this.mChart.getRotationAngle();
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        float off = r / 10.0f * 3.6f;
        if (this.mChart.isDrawHoleEnabled()) {
            off = (r - r / 100.0f * this.mChart.getHoleRadius()) / 2.0f;
        }
        r -= off;
        PieData data = (PieData)this.mChart.getData();
        List dataSets = data.getDataSets();
        boolean drawXVals = this.mChart.isDrawSliceTextEnabled();
        int cnt = 0;
        for (int i = 0; i < dataSets.size(); ++i) {
            PieDataSet dataSet = (PieDataSet)dataSets.get(i);
            if (!dataSet.isDrawValuesEnabled() && !drawXVals) continue;
            this.applyValueTextStyle(dataSet);
            List entries = dataSet.getYVals();
            int maxEntry = Math.min((int)Math.ceil((float)entries.size() * this.mAnimator.getPhaseX()), entries.size());
            for (int j = 0; j < maxEntry; ++j) {
                float offset = drawAngles[cnt] / 2.0f;
                float x = (float)((double)r * Math.cos(Math.toRadians((rotationAngle + absoluteAngles[cnt] - offset) * this.mAnimator.getPhaseY())) + (double)center.x);
                float y = (float)((double)r * Math.sin(Math.toRadians((rotationAngle + absoluteAngles[cnt] - offset) * this.mAnimator.getPhaseY())) + (double)center.y);
                float value = this.mChart.isUsePercentValuesEnabled() ? ((Entry)entries.get(j)).getVal() / this.mChart.getYValueSum() * 100.0f : ((Entry)entries.get(j)).getVal();
                String val = dataSet.getValueFormatter().getFormattedValue(value);
                float lineHeight = (float)Utils.calcTextHeight(this.mValuePaint, val) + Utils.convertDpToPixel(4.0f);
                boolean drawYVals = dataSet.isDrawValuesEnabled();
                if (drawXVals && drawYVals) {
                    c.drawText(val, x, y, this.mValuePaint);
                    if (j < data.getXValCount()) {
                        c.drawText(data.getXVals().get(j), x, y + lineHeight, this.mValuePaint);
                    }
                } else if (drawXVals && !drawYVals) {
                    if (j < data.getXValCount()) {
                        c.drawText(data.getXVals().get(j), x, y + lineHeight / 2.0f, this.mValuePaint);
                    }
                } else if (!drawXVals && drawYVals) {
                    c.drawText(val, x, y + lineHeight / 2.0f, this.mValuePaint);
                }
                ++cnt;
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawHole(c);
        c.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mRenderPaint);
        this.drawCenterText(c);
    }

    protected void drawHole(Canvas c) {
        if (this.mChart.isDrawHoleEnabled()) {
            float transparentCircleRadius = this.mChart.getTransparentCircleRadius();
            float holeRadius = this.mChart.getHoleRadius();
            float radius = this.mChart.getRadius();
            PointF center = this.mChart.getCenterCircleBox();
            if (transparentCircleRadius > holeRadius && this.mAnimator.getPhaseX() >= 1.0f && this.mAnimator.getPhaseY() >= 1.0f) {
                int color = this.mTransparentCirclePaint.getColor();
                this.mTransparentCirclePaint.setColor(color & 0x60FFFFFF);
                this.mBitmapCanvas.drawCircle(center.x, center.y, radius / 100.0f * transparentCircleRadius, this.mTransparentCirclePaint);
                this.mTransparentCirclePaint.setColor(color);
            }
            this.mBitmapCanvas.drawCircle(center.x, center.y, radius / 100.0f * holeRadius, this.mHolePaint);
        }
    }

    protected void drawCenterText(Canvas c) {
        String centerText = this.mChart.getCenterText();
        if (this.mChart.isDrawCenterTextEnabled() && centerText != null) {
            PointF center = this.mChart.getCenterCircleBox();
            if (this.mChart.isCenterTextWordWrapEnabled()) {
                float innerRadius = this.mChart.isDrawHoleEnabled() && this.mChart.isHoleTransparent() ? this.mChart.getRadius() * (this.mChart.getHoleRadius() / 100.0f) : this.mChart.getRadius();
                RectF holeRect = this.mRectBuffer[0];
                holeRect.left = center.x - innerRadius;
                holeRect.top = center.y - innerRadius;
                holeRect.right = center.x + innerRadius;
                holeRect.bottom = center.y + innerRadius;
                RectF boundingRect = this.mRectBuffer[1];
                boundingRect.set(holeRect);
                float radiusPercent = this.mChart.getCenterTextRadiusPercent();
                if ((double)radiusPercent > 0.0) {
                    boundingRect.inset((boundingRect.width() - boundingRect.width() * radiusPercent) / 2.0f, (boundingRect.height() - boundingRect.height() * radiusPercent) / 2.0f);
                }
                if (!centerText.equals(this.mCenterTextLastValue) || !boundingRect.equals((Object)this.mCenterTextLastBounds)) {
                    this.mCenterTextLastBounds.set(boundingRect);
                    this.mCenterTextLastValue = centerText;
                    this.mCenterTextLayout = new StaticLayout((CharSequence)centerText, 0, centerText.length(), this.mCenterTextPaint, (int)Math.max(Math.ceil(this.mCenterTextLastBounds.width()), 1.0), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                }
                float layoutHeight = this.mCenterTextLayout.getHeight();
                c.save();
                c.translate(boundingRect.centerX(), boundingRect.top + (boundingRect.height() - layoutHeight) / 2.0f);
                this.mCenterTextLayout.draw(c);
                c.restore();
            } else {
                String[] lines = centerText.split("\n");
                float maxlineheight = 0.0f;
                for (String line : lines) {
                    float curHeight = Utils.calcTextHeight((Paint)this.mCenterTextPaint, line);
                    if (!(curHeight > maxlineheight)) continue;
                    maxlineheight = curHeight;
                }
                float linespacing = maxlineheight * 0.25f;
                float totalheight = maxlineheight * (float)lines.length - linespacing * (float)(lines.length - 1);
                int cnt = lines.length;
                float y = center.y;
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[lines.length - i - 1];
                    c.drawText(line, center.x, y + maxlineheight * (float)cnt - totalheight / 2.0f, (Paint)this.mCenterTextPaint);
                    --cnt;
                    y -= linespacing;
                }
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        float rotationAngle = this.mChart.getRotationAngle();
        float angle = 0.0f;
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        for (int i = 0; i < indices.length; ++i) {
            PieDataSet set;
            int xIndex = indices[i].getXIndex();
            if (xIndex >= drawAngles.length || (set = ((PieData)this.mChart.getData()).getDataSetByIndex(indices[i].getDataSetIndex())) == null || !set.isHighlightEnabled()) continue;
            angle = xIndex == 0 ? rotationAngle : rotationAngle + absoluteAngles[xIndex - 1];
            angle *= this.mAnimator.getPhaseY();
            float sliceDegrees = drawAngles[xIndex];
            float shift = set.getSelectionShift();
            RectF circleBox = this.mChart.getCircleBox();
            RectF highlighted = new RectF(circleBox.left - shift, circleBox.top - shift, circleBox.right + shift, circleBox.bottom + shift);
            this.mRenderPaint.setColor(set.getColor(xIndex));
            this.mBitmapCanvas.drawArc(highlighted, angle + set.getSliceSpace() / 2.0f, sliceDegrees * this.mAnimator.getPhaseY() - set.getSliceSpace() / 2.0f, true, this.mRenderPaint);
        }
    }

    protected void drawRoundedSlices(Canvas c) {
        if (!this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        PieDataSet dataSet = ((PieData)this.mChart.getData()).getDataSet();
        if (!dataSet.isVisible()) {
            return;
        }
        PointF center = this.mChart.getCenterCircleBox();
        float r = this.mChart.getRadius();
        float circleRadius = (r - r * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        List entries = dataSet.getYVals();
        float[] drawAngles = this.mChart.getDrawAngles();
        float angle = this.mChart.getRotationAngle();
        for (int j = 0; j < entries.size(); ++j) {
            float newangle = drawAngles[j];
            Entry e = (Entry)entries.get(j);
            if ((double)Math.abs(e.getVal()) > 1.0E-6) {
                float x = (float)((double)(r - circleRadius) * Math.cos(Math.toRadians((angle + newangle) * this.mAnimator.getPhaseY())) + (double)center.x);
                float y = (float)((double)(r - circleRadius) * Math.sin(Math.toRadians((angle + newangle) * this.mAnimator.getPhaseY())) + (double)center.y);
                this.mRenderPaint.setColor(dataSet.getColor(j));
                this.mBitmapCanvas.drawCircle(x, y, circleRadius, this.mRenderPaint);
            }
            angle += newangle * this.mAnimator.getPhaseX();
        }
    }
}

