/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.interfaces.BarLineScatterCandleDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.BubbleChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class CombinedChartRenderer
extends DataRenderer {
    protected List<DataRenderer> mRenderers;

    public CombinedChartRenderer(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.createRenderers(chart, animator, viewPortHandler);
    }

    protected void createRenderers(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        CombinedChart.DrawOrder[] orders;
        this.mRenderers = new ArrayList<DataRenderer>();
        block7: for (CombinedChart.DrawOrder order : orders = chart.getDrawOrder()) {
            switch (order) {
                case BAR: {
                    if (chart.getBarData() == null) continue block7;
                    this.mRenderers.add(new BarChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case BUBBLE: {
                    if (chart.getBubbleData() == null) continue block7;
                    this.mRenderers.add(new BubbleChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case LINE: {
                    if (chart.getLineData() == null) continue block7;
                    this.mRenderers.add(new LineChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case CANDLE: {
                    if (chart.getCandleData() == null) continue block7;
                    this.mRenderers.add(new CandleStickChartRenderer(chart, animator, viewPortHandler));
                    continue block7;
                }
                case SCATTER: {
                    if (chart.getScatterData() == null) continue block7;
                    this.mRenderers.add(new ScatterChartRenderer(chart, animator, viewPortHandler));
                }
            }
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawData(c);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawExtras(c);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawHighlighted(c, indices);
        }
    }

    @Override
    public void calcXBounds(BarLineScatterCandleDataProvider chart, int xAxisModulus) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.calcXBounds(chart, xAxisModulus);
        }
    }

    public DataRenderer getSubRenderer(int index) {
        if (index >= this.mRenderers.size() || index < 0) {
            return null;
        }
        return this.mRenderers.get(index);
    }
}

