/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarEntry;
import java.util.List;

public class HorizontalBarBuffer
extends BarBuffer {
    public HorizontalBarBuffer(int size, float groupspace, int dataSetCount, boolean containsStacks) {
        super(size, groupspace, dataSetCount, containsStacks);
    }

    @Override
    public void feed(List<BarEntry> entries) {
        float size = (float)entries.size() * this.phaseX;
        int dataSetOffset = this.mDataSetCount - 1;
        float barSpaceHalf = this.mBarSpace / 2.0f;
        float groupSpaceHalf = this.mGroupSpace / 2.0f;
        float barWidth = 0.5f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e = entries.get(i);
            float x = (float)(e.getXIndex() + i * dataSetOffset + this.mDataSetIndex) + this.mGroupSpace * (float)i + groupSpaceHalf;
            float y = e.getVal();
            float[] vals = e.getVals();
            if (!this.mContainsStacks || vals == null) {
                float right;
                float left;
                float bottom = x - barWidth + barSpaceHalf;
                float top = x + barWidth - barSpaceHalf;
                if (this.mInverted) {
                    left = y >= 0.0f ? y : 0.0f;
                    right = y <= 0.0f ? y : 0.0f;
                } else {
                    right = y >= 0.0f ? y : 0.0f;
                    float f = left = y <= 0.0f ? y : 0.0f;
                }
                if (right > 0.0f) {
                    right *= this.phaseY;
                } else {
                    left *= this.phaseY;
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = 0.0f;
                float yStart = 0.0f;
                for (int k = 0; k < vals.length; ++k) {
                    float right;
                    float left;
                    float value = vals[k];
                    if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        negY = yStart = negY + value;
                    }
                    float bottom = x - barWidth + barSpaceHalf;
                    float top = x + barWidth - barSpaceHalf;
                    if (this.mInverted) {
                        left = y >= yStart ? y : yStart;
                        right = y <= yStart ? y : yStart;
                    } else {
                        right = y >= yStart ? y : yStart;
                        left = y <= yStart ? y : yStart;
                    }
                    this.addBar(left *= this.phaseY, top, right *= this.phaseY, bottom);
                }
            }
            ++i;
        }
        this.reset();
    }
}

