/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import com.github.mikephil.charting.utils.ValueFormatter;
import java.text.DecimalFormat;

public class LargeValueFormatter
implements ValueFormatter {
    private static String[] SUFFIX = new String[]{"", "k", "m", "b", "t"};
    private static int MAX_LENGTH = 4;
    private DecimalFormat mFormat = new DecimalFormat("###E0");

    @Override
    public String getFormattedValue(float value) {
        return this.makePretty(value);
    }

    private String makePretty(double number) {
        String r = this.mFormat.format(number);
        r = r.replaceAll("E[0-9]", SUFFIX[Character.getNumericValue(r.charAt(r.length() - 1)) / 3]);
        while (r.length() > MAX_LENGTH || r.matches("[0-9]+\\.[a-z]")) {
            r = r.substring(0, r.length() - 2) + r.substring(r.length() - 1);
        }
        return r;
    }
}

