/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class XAxisRendererHorizontalBarChart
extends XAxisRendererBarChart {
    public XAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer trans, BarChart chart) {
        super(viewPortHandler, xAxis, trans, chart);
    }

    @Override
    public void computeAxis(float xValAverageLength, List<String> xValues) {
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mXAxis.setValues(xValues);
        String longest = this.mXAxis.getLongestLabel();
        this.mXAxis.mLabelWidth = (int)((float)Utils.calcTextWidth(this.mAxisLabelPaint, longest) + this.mXAxis.getXOffset() * 3.5f);
        this.mXAxis.mLabelHeight = Utils.calcTextHeight(this.mAxisLabelPaint, longest);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float xoffset = this.mXAxis.getXOffset();
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.LEFT);
            this.drawLabels(c, this.mViewPortHandler.contentRight() + xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawLabels(c, this.mViewPortHandler.contentLeft() - xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.LEFT);
            this.drawLabels(c, this.mViewPortHandler.contentLeft() + xoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.mAxisLabelPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawLabels(c, this.mViewPortHandler.contentRight() - xoffset);
        } else {
            this.drawLabels(c, this.mViewPortHandler.contentLeft());
            this.drawLabels(c, this.mViewPortHandler.contentRight());
        }
    }

    @Override
    protected void drawLabels(Canvas c, float pos) {
        float[] position = new float[]{0.0f, 0.0f};
        BarData bd = (BarData)this.mChart.getData();
        int step = bd.getDataSetCount();
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[1] = (float)(i * step) + (float)i * bd.getGroupSpace() + bd.getGroupSpace() / 2.0f;
            if (step > 1) {
                position[1] = position[1] + ((float)step - 1.0f) / 2.0f;
            }
            this.mTrans.pointValuesToPixel(position);
            if (!this.mViewPortHandler.isInBoundsY(position[1])) continue;
            String label = this.mXAxis.getValues().get(i);
            c.drawText(label, pos, position[1] + (float)this.mXAxis.mLabelHeight / 2.0f, this.mAxisLabelPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        BarData bd = (BarData)this.mChart.getData();
        int step = bd.getDataSetCount();
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[1] = (float)(i * step) + (float)i * bd.getGroupSpace() - 0.5f;
            this.mTrans.pointValuesToPixel(position);
            if (!this.mViewPortHandler.isInBoundsY(position[1])) continue;
            c.drawLine(this.mViewPortHandler.contentLeft(), position[1], this.mViewPortHandler.contentRight(), position[1], this.mGridPaint);
        }
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mXAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = new float[2];
        Path limitLinePath = new Path();
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            pts[1] = l.getLimit();
            this.mTrans.pointValuesToPixel(pts);
            limitLinePath.moveTo(this.mViewPortHandler.contentLeft(), pts[1]);
            limitLinePath.lineTo(this.mViewPortHandler.contentRight(), pts[1]);
            c.drawPath(limitLinePath, this.mLimitLinePaint);
            limitLinePath.reset();
            String label = l.getLabel();
            if (label == null || label.equals("")) continue;
            float xOffset = Utils.convertDpToPixel(4.0f);
            float yOffset = l.getLineWidth() + (float)Utils.calcTextHeight(this.mLimitLinePaint, label) / 2.0f;
            this.mLimitLinePaint.setStyle(l.getTextStyle());
            this.mLimitLinePaint.setPathEffect(null);
            this.mLimitLinePaint.setColor(l.getTextColor());
            this.mLimitLinePaint.setStrokeWidth(0.5f);
            this.mLimitLinePaint.setTextSize(l.getTextSize());
            if (l.getLabelPosition() == LimitLine.LimitLabelPosition.POS_RIGHT) {
                this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                c.drawText(label, this.mViewPortHandler.contentRight() - xOffset, pts[1] - yOffset, this.mLimitLinePaint);
                continue;
            }
            this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
            c.drawText(label, this.mViewPortHandler.offsetLeft() + xOffset, pts[1] - yOffset, this.mLimitLinePaint);
        }
    }
}

