/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    private float mYOffset = 0.0f;

    public HorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            BarDataSet set = (BarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new HorizontalBarBuffer(set.getValueCount() * 4 * set.getStackSize(), barData.getGroupSpace(), barData.getDataSetCount(), set.isStacked());
        }
    }

    @Override
    protected void drawDataSet(Canvas c, BarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.calcXBounds(trans);
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List<BarEntry> entries = dataSet.getYVals();
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setBarSpace(dataSet.getBarSpace());
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.feed(entries);
        trans.pointValuesToPixel(buffer.buffer);
        for (int j = 0; j < buffer.size() && this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3]); j += 4) {
            if (!this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) continue;
            if (this.mChart.isDrawBarShadowEnabled()) {
                c.drawRect(this.mViewPortHandler.contentLeft(), buffer.buffer[j + 1], this.mViewPortHandler.contentRight(), buffer.buffer[j + 3], this.mShadowPaint);
            }
            this.mRenderPaint.setColor(dataSet.getColor(j / 4));
            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        block13: {
            if (!this.passesCheck()) break block13;
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            if (drawValueAboveBar) {
                this.mValuePaint.setTextAlign(Paint.Align.LEFT);
            } else {
                this.mValuePaint.setTextAlign(Paint.Align.RIGHT);
            }
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                int j;
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                this.applyValueTextStyle(dataSet);
                this.mYOffset = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                ValueFormatter formatter = dataSet.getValueFormatter();
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                List<BarEntry> entries = dataSet.getYVals();
                float[] valuePoints = this.getTransformedValues(trans, entries, i);
                if (!this.mChart.isDrawValuesForWholeStackEnabled()) {
                    j = 0;
                    while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX()) {
                        if (this.mViewPortHandler.isInBoundsX(valuePoints[j])) {
                            if (!this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) continue block0;
                            if (this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) {
                                float val = entries.get(j / 2).getVal();
                                String valueText = formatter.getFormattedValue(val);
                                float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, valueText);
                                posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                if (isInverted) {
                                    posOffset = -posOffset - valueTextWidth;
                                    negOffset = -negOffset - valueTextWidth;
                                }
                                this.drawValue(c, valueText, valuePoints[j] + (val >= 0.0f ? posOffset : negOffset), valuePoints[j + 1]);
                            }
                        }
                        j += 2;
                    }
                    continue;
                }
                j = 0;
                while ((float)j < (float)(valuePoints.length - 1) * this.mAnimator.getPhaseX()) {
                    block15: {
                        int k;
                        float[] vals;
                        BarEntry e;
                        block14: {
                            e = entries.get(j / 2);
                            vals = e.getVals();
                            if (vals != null) break block14;
                            if (!this.mViewPortHandler.isInBoundsX(valuePoints[j])) break block15;
                            if (!this.mViewPortHandler.isInBoundsTop(valuePoints[j + 1])) continue block0;
                            if (!this.mViewPortHandler.isInBoundsBottom(valuePoints[j + 1])) break block15;
                            float val = e.getVal();
                            String valueText = formatter.getFormattedValue(val);
                            float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, valueText);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            this.drawValue(c, valueText, valuePoints[j] + (e.getVal() >= 0.0f ? posOffset : negOffset), valuePoints[j + 1]);
                            break block15;
                        }
                        float[] transformed = new float[vals.length * 2];
                        int cnt = 0;
                        float add = e.getVal();
                        for (k = 0; k < transformed.length; k += 2) {
                            transformed[k] = (vals[cnt] + (add -= vals[cnt])) * this.mAnimator.getPhaseY();
                            ++cnt;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float val = vals[k / 2];
                            String valueText = formatter.getFormattedValue(val);
                            float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, valueText);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            float x = transformed[k] + (val >= 0.0f ? posOffset : negOffset);
                            float y = valuePoints[j + 1];
                            if (!this.mViewPortHandler.isInBoundsX(x)) continue;
                            if (!this.mViewPortHandler.isInBoundsTop(y)) break;
                            if (!this.mViewPortHandler.isInBoundsBottom(y)) continue;
                            this.drawValue(c, valueText, x, y);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    @Override
    protected void prepareBarHighlight(float x, float y, float barspaceHalf, float from, Transformer trans) {
        float top = x - 0.5f + barspaceHalf;
        float bottom = x + 0.5f - barspaceHalf;
        float left = y >= from ? y : from;
        float right = y <= from ? y : from;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixelHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public float[] getTransformedValues(Transformer trans, List<BarEntry> entries, int dataSetIndex) {
        return trans.generateTransformedValuesHorizontalBarChart(entries, dataSetIndex, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    @Override
    protected void drawValue(Canvas c, String value, float xPos, float yPos) {
        super.drawValue(c, value, xPos, yPos + this.mYOffset);
    }

    @Override
    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

