/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import java.util.List;

public class PieRadarChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final int NONE = 0;
    private static final int ROTATE = 1;
    private PointF mTouchStartPoint = new PointF();
    private PieRadarChartBase<?> mChart;
    private int mTouchMode = 0;
    private GestureDetector mGestureDetector;
    private Highlight mLastHighlight = null;

    public PieRadarChartTouchListener(PieRadarChartBase<?> ctx) {
        this.mChart = ctx;
        this.mGestureDetector = new GestureDetector(ctx.getContext(), (GestureDetector.OnGestureListener)this);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent e) {
        if (this.mGestureDetector.onTouchEvent(e)) {
            return true;
        }
        if (this.mChart.isRotationEnabled()) {
            float x = e.getX();
            float y = e.getY();
            switch (e.getAction()) {
                case 0: {
                    this.mChart.setStartAngle(x, y);
                    this.mTouchStartPoint.x = x;
                    this.mTouchStartPoint.y = y;
                    break;
                }
                case 2: {
                    if (this.mTouchMode == 0 && PieRadarChartTouchListener.distance(x, this.mTouchStartPoint.x, y, this.mTouchStartPoint.y) > Utils.convertDpToPixel(8.0f)) {
                        this.mTouchMode = 1;
                        this.mChart.disableScroll();
                        break;
                    }
                    if (this.mTouchMode != 1) break;
                    this.mChart.updateRotation(x, y);
                    this.mChart.invalidate();
                    break;
                }
                case 1: {
                    this.mChart.enableScroll();
                    this.mTouchMode = 0;
                }
            }
        }
        return true;
    }

    public void onLongPress(MotionEvent me) {
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartLongPressed(me);
        }
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        float distance;
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartSingleTapped(e);
        }
        if ((distance = this.mChart.distanceToCenter(e.getX(), e.getY())) > this.mChart.getRadius()) {
            this.mChart.highlightValues(null);
            this.mLastHighlight = null;
        } else {
            int index;
            float angle = this.mChart.getAngleForPoint(e.getX(), e.getY());
            if (this.mChart instanceof PieChart) {
                angle /= this.mChart.getAnimator().getPhaseY();
            }
            if ((index = this.mChart.getIndexForAngle(angle)) < 0) {
                this.mChart.highlightValues(null);
                this.mLastHighlight = null;
            } else {
                Highlight h;
                List<SelInfo> valsAtIndex = this.mChart.getYValsAtIndex(index);
                int dataSetIndex = 0;
                if (this.mChart instanceof RadarChart) {
                    dataSetIndex = Utils.getClosestDataSetIndex(valsAtIndex, distance / ((RadarChart)this.mChart).getFactor(), null);
                }
                if ((h = new Highlight(index, dataSetIndex)).equalTo(this.mLastHighlight)) {
                    this.mChart.highlightTouch(null);
                    this.mLastHighlight = null;
                } else {
                    this.mChart.highlightTouch(h);
                    this.mLastHighlight = h;
                }
            }
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartDoubleTapped(e);
        }
        return super.onDoubleTap(e);
    }

    private static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }
}

