/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarEntry;
import java.util.List;

public class HorizontalBarBuffer
extends BarBuffer {
    public HorizontalBarBuffer(int size, float groupspace, int dataSetCount, boolean containsStacks) {
        super(size, groupspace, dataSetCount, containsStacks);
    }

    @Override
    public void feed(List<BarEntry> entries) {
        float size = (float)entries.size() * this.phaseX;
        int dataSetOffset = this.mDataSetCount - 1;
        float barSpaceHalf = this.mBarSpace / 2.0f;
        float groupSpaceHalf = this.mGroupSpace / 2.0f;
        float barWidth = 0.5f;
        int i = 0;
        while ((float)i < size) {
            float top;
            float bottom;
            float all;
            float bottom2;
            BarEntry e = entries.get(i);
            float x = (float)(e.getXIndex() + i * dataSetOffset + this.mDataSetIndex) + this.mGroupSpace * (float)i + groupSpaceHalf;
            float y = e.getVal();
            float[] vals = e.getVals();
            if (this.mInverted) {
                if (!this.mContainsStacks || vals == null) {
                    float right;
                    bottom2 = x - barWidth + barSpaceHalf;
                    float top2 = x + barWidth - barSpaceHalf;
                    float left = y >= 0.0f ? y : 0.0f;
                    float f = right = y <= 0.0f ? y : 0.0f;
                    if (right > 0.0f) {
                        right *= this.phaseY;
                    } else {
                        left *= this.phaseY;
                    }
                    this.addBar(left, top2, right, bottom2);
                } else {
                    all = e.getVal();
                    for (int k = 0; k < vals.length; ++k) {
                        float right;
                        y = vals[k] + (all -= vals[k]);
                        bottom = x - barWidth + barSpaceHalf;
                        top = x + barWidth - barSpaceHalf;
                        float left = y >= 0.0f ? y : 0.0f;
                        float f = right = y <= 0.0f ? y : 0.0f;
                        if (right > 0.0f) {
                            right *= this.phaseY;
                        } else {
                            left *= this.phaseY;
                        }
                        this.addBar(left, top, right, bottom);
                    }
                }
            } else if (!this.mContainsStacks || vals == null) {
                float left;
                bottom2 = x - barWidth + barSpaceHalf;
                float top3 = x + barWidth - barSpaceHalf;
                float right = y >= 0.0f ? y : 0.0f;
                float f = left = y <= 0.0f ? y : 0.0f;
                if (right > 0.0f) {
                    right *= this.phaseY;
                } else {
                    left *= this.phaseY;
                }
                this.addBar(left, top3, right, bottom2);
            } else {
                all = e.getVal();
                for (int k = 0; k < vals.length; ++k) {
                    float left;
                    y = vals[k] + (all -= vals[k]);
                    bottom = x - barWidth + barSpaceHalf;
                    top = x + barWidth - barSpaceHalf;
                    float right = y >= 0.0f ? y : 0.0f;
                    float f = left = y <= 0.0f ? y : 0.0f;
                    if (right > 0.0f) {
                        right *= this.phaseY;
                    } else {
                        left *= this.phaseY;
                    }
                    this.addBar(left, top, right, bottom);
                }
            }
            ++i;
        }
        this.reset();
    }
}

