/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.BarEntry;
import java.util.List;

public class BarBuffer
extends AbstractBuffer<BarEntry> {
    protected float mBarSpace = 0.0f;
    protected float mGroupSpace = 0.0f;
    protected int mDataSetIndex = 0;
    protected int mDataSetCount = 1;
    protected boolean mContainsStacks = false;
    protected boolean mInverted = false;

    public BarBuffer(int size, float groupspace, int dataSetCount, boolean containsStacks) {
        super(size);
        this.mGroupSpace = groupspace;
        this.mDataSetCount = dataSetCount;
        this.mContainsStacks = containsStacks;
    }

    public void setBarSpace(float barspace) {
        this.mBarSpace = barspace;
    }

    public void setDataSet(int index) {
        this.mDataSetIndex = index;
    }

    public void setInverted(boolean inverted) {
        this.mInverted = inverted;
    }

    protected void addBar(float left, float top, float right, float bottom) {
        this.buffer[this.index++] = left;
        this.buffer[this.index++] = top;
        this.buffer[this.index++] = right;
        this.buffer[this.index++] = bottom;
    }

    @Override
    public void feed(List<BarEntry> entries) {
        float size = (float)entries.size() * this.phaseX;
        int dataSetOffset = this.mDataSetCount - 1;
        float barSpaceHalf = this.mBarSpace / 2.0f;
        float groupSpaceHalf = this.mGroupSpace / 2.0f;
        float barWidth = 0.5f;
        int i = 0;
        while ((float)i < size) {
            float right;
            float left;
            float all;
            float left2;
            BarEntry e = entries.get(i);
            float x = (float)(e.getXIndex() + i * dataSetOffset + this.mDataSetIndex) + this.mGroupSpace * (float)i + groupSpaceHalf;
            float y = e.getVal();
            float[] vals = e.getVals();
            if (this.mInverted) {
                if (!this.mContainsStacks || vals == null) {
                    float top;
                    left2 = x - barWidth + barSpaceHalf;
                    float right2 = x + barWidth - barSpaceHalf;
                    float bottom = y >= 0.0f ? y : 0.0f;
                    float f = top = y <= 0.0f ? y : 0.0f;
                    if (top > 0.0f) {
                        top *= this.phaseY;
                    } else {
                        bottom *= this.phaseY;
                    }
                    this.addBar(left2, top, right2, bottom);
                } else {
                    all = e.getVal();
                    for (int k = 0; k < vals.length; ++k) {
                        float top;
                        y = vals[k] + (all -= vals[k]);
                        left = x - barWidth + barSpaceHalf;
                        right = x + barWidth - barSpaceHalf;
                        float bottom = y >= 0.0f ? y : 0.0f;
                        float f = top = y <= 0.0f ? y : 0.0f;
                        if (top > 0.0f) {
                            top *= this.phaseY;
                        } else {
                            bottom *= this.phaseY;
                        }
                        this.addBar(left, top, right, bottom);
                    }
                }
            } else if (!this.mContainsStacks || vals == null) {
                float bottom;
                left2 = x - barWidth + barSpaceHalf;
                float right3 = x + barWidth - barSpaceHalf;
                float top = y >= 0.0f ? y : 0.0f;
                float f = bottom = y <= 0.0f ? y : 0.0f;
                if (top > 0.0f) {
                    top *= this.phaseY;
                } else {
                    bottom *= this.phaseY;
                }
                this.addBar(left2, top, right3, bottom);
            } else {
                all = e.getVal();
                for (int k = 0; k < vals.length; ++k) {
                    float bottom;
                    y = vals[k] + (all -= vals[k]);
                    left = x - barWidth + barSpaceHalf;
                    right = x + barWidth - barSpaceHalf;
                    float top = y >= 0.0f ? y : 0.0f;
                    float f = bottom = y <= 0.0f ? y : 0.0f;
                    if (top > 0.0f) {
                        top *= this.phaseY;
                    } else {
                        bottom *= this.phaseY;
                    }
                    this.addBar(left, top, right, bottom);
                }
            }
            ++i;
        }
        this.reset();
    }
}

