/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleData;
import com.github.mikephil.charting.data.BarLineScatterCandleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class BarLineChartTouchListener<T extends BarLineChartBase<? extends BarLineScatterCandleData<? extends BarLineScatterCandleDataSet<? extends Entry>>>>
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private Matrix mMatrix = new Matrix();
    private Matrix mSavedMatrix = new Matrix();
    private PointF mTouchStartPoint = new PointF();
    private PointF mTouchPointCenter = new PointF();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int X_ZOOM = 2;
    private static final int Y_ZOOM = 3;
    private static final int PINCH_ZOOM = 4;
    private static final int POST_ZOOM = 5;
    private int mTouchMode = 0;
    private float mSavedXDist = 1.0f;
    private float mSavedYDist = 1.0f;
    private float mSavedDist = 1.0f;
    private Highlight mLastHighlighted;
    private DataSet<?> mClosestDataSetToTouch;
    private T mChart;
    private GestureDetector mGestureDetector;

    public BarLineChartTouchListener(T chart, Matrix touchMatrix) {
        this.mChart = chart;
        this.mMatrix = touchMatrix;
        this.mGestureDetector = new GestureDetector(chart.getContext(), (GestureDetector.OnGestureListener)this);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        if (this.mTouchMode == 0) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (!(((BarLineChartBase)this.mChart).isDragEnabled() || ((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled())) {
            return true;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.saveTouchStart(event);
                break;
            }
            case 5: {
                if (event.getPointerCount() < 2) break;
                ((Chart)this.mChart).disableScroll();
                this.saveTouchStart(event);
                this.mSavedXDist = BarLineChartTouchListener.getXDist(event);
                this.mSavedYDist = BarLineChartTouchListener.getYDist(event);
                this.mSavedDist = BarLineChartTouchListener.spacing(event);
                if (this.mSavedDist > 10.0f) {
                    this.mTouchMode = ((BarLineChartBase)this.mChart).isPinchZoomEnabled() ? 4 : (this.mSavedXDist > this.mSavedYDist ? 2 : 3);
                }
                BarLineChartTouchListener.midPoint(this.mTouchPointCenter, event);
                break;
            }
            case 2: {
                if (this.mTouchMode == 1) {
                    ((Chart)this.mChart).disableScroll();
                    if (!((BarLineChartBase)this.mChart).isDragEnabled()) break;
                    this.performDrag(event);
                    break;
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) {
                    ((Chart)this.mChart).disableScroll();
                    if (!((BarLineChartBase)this.mChart).isScaleXEnabled() && !((BarLineChartBase)this.mChart).isScaleYEnabled()) break;
                    this.performZoom(event);
                    break;
                }
                if (this.mTouchMode != 0 || !(Math.abs(BarLineChartTouchListener.distance(event.getX(), this.mTouchStartPoint.x, event.getY(), this.mTouchStartPoint.y)) > 5.0f)) break;
                if (((BarLineChartBase)this.mChart).hasNoDragOffset()) {
                    if (((BarLineChartBase)this.mChart).isFullyZoomedOut()) break;
                    this.mTouchMode = 1;
                    break;
                }
                this.mTouchMode = 1;
                break;
            }
            case 1: {
                this.mTouchMode = 0;
                ((Chart)this.mChart).enableScroll();
                break;
            }
            case 6: {
                this.mTouchMode = 5;
            }
        }
        this.mMatrix = ((Chart)this.mChart).getViewPortHandler().refresh(this.mMatrix, (View)this.mChart, true);
        return true;
    }

    private void saveTouchStart(MotionEvent event) {
        this.mSavedMatrix.set(this.mMatrix);
        this.mTouchStartPoint.set(event.getX(), event.getY());
        this.mClosestDataSetToTouch = ((BarLineChartBase)this.mChart).getDataSetByTouchPoint(event.getX(), event.getY());
    }

    private void performDrag(MotionEvent event) {
        this.mMatrix.set(this.mSavedMatrix);
        if (((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).getAxis(this.mClosestDataSetToTouch.getAxisDependency()).isInverted()) {
            if (this.mChart instanceof HorizontalBarChart) {
                this.mMatrix.postTranslate(-(event.getX() - this.mTouchStartPoint.x), event.getY() - this.mTouchStartPoint.y);
            } else {
                this.mMatrix.postTranslate(event.getX() - this.mTouchStartPoint.x, -(event.getY() - this.mTouchStartPoint.y));
            }
        } else {
            this.mMatrix.postTranslate(event.getX() - this.mTouchStartPoint.x, event.getY() - this.mTouchStartPoint.y);
        }
    }

    private void performZoom(MotionEvent event) {
        if (event.getPointerCount() >= 2) {
            OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
            float totalDist = BarLineChartTouchListener.spacing(event);
            if (totalDist > 10.0f) {
                PointF t = this.getTrans(this.mTouchPointCenter.x, this.mTouchPointCenter.y);
                if (this.mTouchMode == 4) {
                    float scale = totalDist / this.mSavedDist;
                    float scaleX = ((BarLineChartBase)this.mChart).isScaleXEnabled() ? scale : 1.0f;
                    float scaleY = ((BarLineChartBase)this.mChart).isScaleYEnabled() ? scale : 1.0f;
                    this.mMatrix.set(this.mSavedMatrix);
                    this.mMatrix.postScale(scaleX, scaleY, t.x, t.y);
                    if (l != null) {
                        l.onChartScale(event, scaleX, scaleY);
                    }
                } else if (this.mTouchMode == 2 && ((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                    float xDist = BarLineChartTouchListener.getXDist(event);
                    float scaleX = xDist / this.mSavedXDist;
                    this.mMatrix.set(this.mSavedMatrix);
                    this.mMatrix.postScale(scaleX, 1.0f, t.x, t.y);
                    if (l != null) {
                        l.onChartScale(event, scaleX, 1.0f);
                    }
                } else if (this.mTouchMode == 3 && ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                    float yDist = BarLineChartTouchListener.getYDist(event);
                    float scaleY = yDist / this.mSavedYDist;
                    this.mMatrix.set(this.mSavedMatrix);
                    this.mMatrix.postScale(1.0f, scaleY, t.x, t.y);
                    if (l != null) {
                        l.onChartScale(event, 1.0f, scaleY);
                    }
                }
            }
        }
    }

    private void performHighlight(MotionEvent e) {
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h == null || h.equalTo(this.mLastHighlighted)) {
            ((Chart)this.mChart).highlightTouch(null);
            this.mLastHighlighted = null;
        } else {
            this.mLastHighlighted = h;
            ((Chart)this.mChart).highlightTouch(h);
        }
    }

    private void performHighlightDrag(MotionEvent e) {
        Highlight h = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(e.getX(), e.getY());
        if (h != null && !h.equalTo(this.mLastHighlighted)) {
            this.mLastHighlighted = h;
            ((Chart)this.mChart).highlightTouch(h);
        }
    }

    private static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    private static void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    private static float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float getXDist(MotionEvent e) {
        float x = Math.abs(e.getX(0) - e.getX(1));
        return x;
    }

    private static float getYDist(MotionEvent e) {
        float y = Math.abs(e.getY(0) - e.getY(1));
        return y;
    }

    public PointF getTrans(float x, float y) {
        ViewPortHandler vph = ((Chart)this.mChart).getViewPortHandler();
        float xTrans = x - vph.offsetLeft();
        float yTrans = 0.0f;
        yTrans = ((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.mClosestDataSetToTouch != null && ((BarLineChartBase)this.mChart).isInverted(this.mClosestDataSetToTouch.getAxisDependency()) ? -(y - vph.offsetTop()) : -((float)this.mChart.getMeasuredHeight() - y - vph.offsetBottom());
        return new PointF(xTrans, yTrans);
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public boolean onDoubleTap(MotionEvent e) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartDoubleTapped(e);
            return super.onDoubleTap(e);
        }
        if (((BarLineChartBase)this.mChart).isDoubleTapToZoomEnabled()) {
            PointF trans = this.getTrans(e.getX(), e.getY());
            ((BarLineChartBase)this.mChart).zoom(1.4f, 1.4f, trans.x, trans.y);
            if (((Chart)this.mChart).isLogEnabled()) {
                Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + trans.x + ", y: " + trans.y));
            }
        }
        return super.onDoubleTap(e);
    }

    public void onLongPress(MotionEvent e) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartLongPressed(e);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.performHighlight(e);
        return super.onSingleTapUp(e);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartSingleTapped(e);
        }
        return super.onSingleTapConfirmed(e);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        OnChartGestureListener l = ((Chart)this.mChart).getOnChartGestureListener();
        if (l != null) {
            l.onChartFling(e1, e2, velocityX, velocityY);
        }
        return super.onFling(e1, e2, velocityX, velocityY);
    }
}

