/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.renderer.RadarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererRadarChart;
import com.github.mikephil.charting.renderer.YAxisRendererRadarChart;
import com.github.mikephil.charting.utils.Utils;

public class RadarChart
extends PieRadarChartBase<RadarData> {
    private float mWebLineWidth = 2.5f;
    private float mInnerWebLineWidth = 1.5f;
    private int mWebColor = Color.rgb((int)122, (int)122, (int)122);
    private int mWebColorInner = Color.rgb((int)122, (int)122, (int)122);
    private int mWebAlpha = 150;
    private boolean mDrawWeb = true;
    private YAxis mYAxis;
    private XAxis mXAxis;
    protected YAxisRendererRadarChart mYAxisRenderer;
    protected XAxisRendererRadarChart mXAxisRenderer;

    public RadarChart(Context context) {
        super(context);
    }

    public RadarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RadarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mYAxis = new YAxis(YAxis.AxisDependency.LEFT);
        this.mXAxis = new XAxis();
        this.mXAxis.setSpaceBetweenLabels(0);
        this.mWebLineWidth = Utils.convertDpToPixel(1.5f);
        this.mInnerWebLineWidth = Utils.convertDpToPixel(0.75f);
        this.mRenderer = new RadarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mYAxisRenderer = new YAxisRendererRadarChart(this.mViewPortHandler, this.mYAxis, this);
        this.mXAxisRenderer = new XAxisRendererRadarChart(this.mViewPortHandler, this.mXAxis, this);
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        float minLeft = ((RadarData)this.mData).getYMin(YAxis.AxisDependency.LEFT);
        float maxLeft = ((RadarData)this.mData).getYMax(YAxis.AxisDependency.LEFT);
        this.mXChartMax = ((RadarData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        float leftRange = Math.abs(maxLeft - (this.mYAxis.isStartAtZeroEnabled() ? 0.0f : minLeft));
        float topSpaceLeft = leftRange / 100.0f * this.mYAxis.getSpaceTop();
        float bottomSpaceLeft = leftRange / 100.0f * this.mYAxis.getSpaceBottom();
        this.mXChartMax = ((RadarData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        this.mYAxis.mAxisMaximum = !Float.isNaN(this.mYAxis.getAxisMaxValue()) ? this.mYAxis.getAxisMaxValue() : maxLeft + topSpaceLeft;
        float f = this.mYAxis.mAxisMinimum = !Float.isNaN(this.mYAxis.getAxisMinValue()) ? this.mYAxis.getAxisMinValue() : minLeft - bottomSpaceLeft;
        if (this.mYAxis.isStartAtZeroEnabled()) {
            this.mYAxis.mAxisMinimum = 0.0f;
        }
        this.mYAxis.mAxisRange = Math.abs(this.mYAxis.mAxisMaximum - this.mYAxis.mAxisMinimum);
    }

    @Override
    protected float[] getMarkerPosition(Entry e, int dataSetIndex) {
        float angle = this.getSliceAngle() * (float)e.getXIndex() + this.getRotationAngle();
        float val = e.getVal() * this.getFactor();
        PointF c = this.getCenterOffsets();
        PointF p = new PointF((float)((double)c.x + (double)val * Math.cos(Math.toRadians(angle))), (float)((double)c.y + (double)val * Math.sin(Math.toRadians(angle))));
        return new float[]{p.x, p.y};
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax();
        if (this.mYAxis.needsDefaultFormatter()) {
            this.mYAxis.setValueFormatter(this.mDefaultFormatter);
        }
        this.mYAxisRenderer.computeAxis(this.mYAxis.mAxisMinimum, this.mYAxis.mAxisMaximum);
        this.mXAxisRenderer.computeAxis(((RadarData)this.mData).getXValAverageLength(), ((RadarData)this.mData).getXVals());
        this.mLegendRenderer.computeLegend(this.mData);
        this.calculateOffsets();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        this.mXAxisRenderer.renderAxisLabels(canvas);
        if (this.mDrawWeb) {
            this.mRenderer.drawExtras(canvas);
        }
        this.mYAxisRenderer.renderLimitLines(canvas);
        this.mRenderer.drawData(canvas);
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHightlight);
        }
        this.mYAxisRenderer.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawDescription(canvas);
        this.drawMarkers(canvas);
    }

    public float getFactor() {
        RectF content = this.mViewPortHandler.getContentRect();
        return Math.min(content.width() / 2.0f, content.height() / 2.0f) / this.mYAxis.mAxisRange;
    }

    public float getSliceAngle() {
        return 360.0f / (float)((RadarData)this.mData).getXValCount();
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = (angle - this.mRotationAngle + 360.0f) % 360.0f;
        float sliceangle = this.getSliceAngle();
        for (int i = 0; i < ((RadarData)this.mData).getXValCount(); ++i) {
            if (!(sliceangle * (float)(i + 1) - sliceangle / 2.0f > a)) continue;
            return i;
        }
        return 0;
    }

    public YAxis getYAxis() {
        return this.mYAxis;
    }

    public XAxis getXAxis() {
        return this.mXAxis;
    }

    public void setWebLineWidth(float width) {
        this.mWebLineWidth = Utils.convertDpToPixel(width);
    }

    public float getWebLineWidth() {
        return this.mWebLineWidth;
    }

    public void setWebLineWidthInner(float width) {
        this.mInnerWebLineWidth = Utils.convertDpToPixel(width);
    }

    public float getWebLineWidthInner() {
        return this.mInnerWebLineWidth;
    }

    public void setWebAlpha(int alpha) {
        this.mWebAlpha = alpha;
    }

    public int getWebAlpha() {
        return this.mWebAlpha;
    }

    public void setWebColor(int color) {
        this.mWebColor = color;
    }

    public int getWebColor() {
        return this.mWebColor;
    }

    public void setWebColorInner(int color) {
        this.mWebColorInner = color;
    }

    public int getWebColorInner() {
        return this.mWebColorInner;
    }

    public void setDrawWeb(boolean enabled) {
        this.mDrawWeb = enabled;
    }

    @Override
    protected float getRequiredBottomOffset() {
        return this.mLegendRenderer.getLabelPaint().getTextSize() * 6.5f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return this.mXAxis.mLabelWidth;
    }

    @Override
    public float getRadius() {
        RectF content = this.mViewPortHandler.getContentRect();
        return Math.min(content.width() / 2.0f, content.height() / 2.0f);
    }

    @Override
    public float getYChartMax() {
        return this.mYAxis.mAxisMaximum;
    }

    @Override
    public float getYChartMin() {
        return this.mYAxis.mAxisMinimum;
    }

    public float getYRange() {
        return this.mYAxis.mAxisRange;
    }
}

