/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;

public class YAxisRendererHorizontalBarChart
extends YAxisRenderer {
    public YAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer trans) {
        super(viewPortHandler, yAxis, trans);
    }

    @Override
    public void computeAxis(float yMin, float yMax) {
        if (this.mViewPortHandler.contentHeight() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutX()) {
            PointD p1 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            PointD p2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop());
            if (!this.mYAxis.isInverted()) {
                yMin = (float)p1.x;
                yMax = (float)p2.x;
            } else {
                yMin = !this.mYAxis.isStartAtZeroEnabled() ? (float)Math.min(p1.x, p2.x) : 0.0f;
                yMax = (float)Math.max(p1.x, p2.x);
            }
        }
        this.computeAxisValues(yMin, yMax);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = new float[this.mYAxis.mEntryCount * 2];
        for (int i = 0; i < positions.length; i += 2) {
            positions[i] = this.mYAxis.mEntries[i / 2];
        }
        this.mTrans.pointValuesToPixel(positions);
        this.mAxisPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisPaint.setColor(this.mYAxis.getTextColor());
        this.mAxisPaint.setTextAlign(Paint.Align.CENTER);
        float yoffset = (float)Utils.calcTextHeight(this.mAxisPaint, "A") + this.mYAxis.getYOffset();
        YAxis.AxisDependency dependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.mYAxis.getLabelPosition();
        float yPos = 0.0f;
        if (dependency == YAxis.AxisDependency.LEFT) {
            if (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
                yoffset = Utils.convertDpToPixel(3.0f);
                yPos = this.mViewPortHandler.contentTop();
            } else {
                yoffset *= -1.0f;
                yPos = this.mViewPortHandler.contentTop();
            }
        } else if (labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
            yoffset *= -1.0f;
            yPos = this.mViewPortHandler.contentBottom();
        } else {
            yoffset = Utils.convertDpToPixel(4.0f);
            yPos = this.mViewPortHandler.contentBottom();
        }
        this.drawYLabels(c, yPos, positions, yoffset);
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
        } else {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    @Override
    protected void drawYLabels(Canvas c, float fixedPosition, float[] positions, float offset) {
        this.mAxisPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisPaint.setColor(this.mYAxis.getTextColor());
        for (int i = 0; i < this.mYAxis.mEntryCount; ++i) {
            String text = this.mYAxis.getFormattedLabel(i);
            if (!this.mYAxis.isDrawTopYLabelEntryEnabled() && i >= this.mYAxis.mEntryCount - 1) {
                return;
            }
            c.drawText(text, positions[i * 2], fixedPosition - offset, this.mAxisPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mYAxis.isDrawGridLinesEnabled() || !this.mYAxis.isEnabled()) {
            return;
        }
        float[] position = new float[2];
        this.mGridPaint.setColor(this.mYAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
        for (int i = 0; i < this.mYAxis.mEntryCount; ++i) {
            position[0] = this.mYAxis.mEntries[i];
            this.mTrans.pointValuesToPixel(position);
            c.drawLine(position[0], this.mViewPortHandler.contentTop(), position[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
        }
    }
}

