/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class XAxisRenderer
extends AxisRenderer {
    protected XAxis mXAxis;

    public XAxisRenderer(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer trans) {
        super(viewPortHandler, trans);
        this.mXAxis = xAxis;
        this.mAxisPaint.setColor(-16777216);
        this.mAxisPaint.setTextAlign(Paint.Align.CENTER);
        this.mAxisPaint.setTextSize(Utils.convertDpToPixel(10.0f));
    }

    public void computeAxis(float xValAverageLength, ArrayList<String> xValues) {
        this.mAxisPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mXAxis.getTextSize());
        StringBuffer a = new StringBuffer();
        int max = Math.round(xValAverageLength + (float)this.mXAxis.getSpaceBetweenLabels());
        for (int i = 0; i < max; ++i) {
            a.append("h");
        }
        this.mXAxis.mLabelWidth = Utils.calcTextWidth(this.mAxisPaint, a.toString());
        this.mXAxis.mLabelHeight = Utils.calcTextHeight(this.mAxisPaint, "Q");
        this.mXAxis.setValues(xValues);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float yoffset = Utils.convertDpToPixel(4.0f);
        this.mAxisPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() - yoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.drawLabels(c, this.mViewPortHandler.contentBottom() + (float)this.mXAxis.mLabelHeight + yoffset * 1.5f);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.drawLabels(c, this.mViewPortHandler.contentBottom() - yoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() + yoffset + (float)this.mXAxis.mLabelHeight);
        } else {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() - yoffset);
            this.drawLabels(c, this.mViewPortHandler.contentBottom() + (float)this.mXAxis.mLabelHeight + yoffset * 1.6f);
        }
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    protected void drawLabels(Canvas c, float pos) {
        float[] position = new float[]{0.0f, 0.0f};
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[0] = i;
            this.mTrans.pointValuesToPixel(position);
            if (!this.mViewPortHandler.isInBoundsX(position[0])) continue;
            String label = this.mXAxis.getValues().get(i);
            if (this.mXAxis.isAvoidFirstLastClippingEnabled()) {
                float width;
                if (i == this.mXAxis.getValues().size() - 1 && this.mXAxis.getValues().size() > 1) {
                    width = Utils.calcTextWidth(this.mAxisPaint, label);
                    if (width > this.mViewPortHandler.offsetRight() * 2.0f && position[0] + width > this.mViewPortHandler.getChartWidth()) {
                        position[0] = position[0] - width / 2.0f;
                    }
                } else if (i == 0) {
                    width = Utils.calcTextWidth(this.mAxisPaint, label);
                    position[0] = position[0] + width / 2.0f;
                }
            }
            c.drawText(label, position[0], pos, this.mAxisPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        for (int i = 0; i < this.mXAxis.getValues().size(); i += this.mXAxis.mAxisLabelModulus) {
            position[0] = i;
            this.mTrans.pointValuesToPixel(position);
            if (!(position[0] >= this.mViewPortHandler.offsetLeft()) || !(position[0] <= this.mViewPortHandler.getChartWidth())) continue;
            c.drawLine(position[0], this.mViewPortHandler.offsetTop(), position[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
        }
    }
}

