/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Highlight;

public class CombinedChartRenderer
extends DataRenderer {
    private LineChartRenderer mLineRenderer;
    private BarChartRenderer mBarRenderer;
    private CandleStickChartRenderer mCandleRenderer;
    private ScatterChartRenderer mScatterRenderer;

    public CombinedChartRenderer(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        if (chart.getLineData() != null) {
            this.mLineRenderer = new LineChartRenderer(chart, animator, viewPortHandler);
        }
        if (chart.getBarData() != null) {
            this.mBarRenderer = new BarChartRenderer(chart, animator, viewPortHandler);
        }
        if (chart.getScatterData() != null) {
            this.mScatterRenderer = new ScatterChartRenderer(chart, animator, viewPortHandler);
        }
        if (chart.getCandleData() != null) {
            this.mCandleRenderer = new CandleStickChartRenderer(chart, animator, viewPortHandler);
        }
    }

    @Override
    public void drawData(Canvas c) {
        if (this.mBarRenderer != null) {
            this.mBarRenderer.drawData(c);
        }
        if (this.mCandleRenderer != null) {
            this.mCandleRenderer.drawData(c);
        }
        if (this.mLineRenderer != null) {
            this.mLineRenderer.drawData(c);
        }
        if (this.mScatterRenderer != null) {
            this.mScatterRenderer.drawData(c);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.mBarRenderer != null) {
            this.mBarRenderer.drawValues(c);
        }
        if (this.mCandleRenderer != null) {
            this.mCandleRenderer.drawValues(c);
        }
        if (this.mLineRenderer != null) {
            this.mLineRenderer.drawValues(c);
        }
        if (this.mScatterRenderer != null) {
            this.mScatterRenderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        if (this.mBarRenderer != null) {
            this.mBarRenderer.drawExtras(c);
        }
        if (this.mCandleRenderer != null) {
            this.mCandleRenderer.drawExtras(c);
        }
        if (this.mLineRenderer != null) {
            this.mLineRenderer.drawExtras(c);
        }
        if (this.mScatterRenderer != null) {
            this.mScatterRenderer.drawExtras(c);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
    }
}

