/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.ViewPortHandler;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import java.util.ArrayList;

public class BarChartRenderer
extends DataRenderer {
    protected BarDataProvider mChart;
    protected RectF mBarShadow = new RectF();
    protected RectF mBarRect = new RectF();

    public BarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
    }

    @Override
    public void drawData(Canvas c) {
        BarData barData = this.mChart.getBarData();
        for (int i = 0; i < barData.getDataSetCount(); ++i) {
            BarDataSet set = (BarDataSet)barData.getDataSetByIndex(i);
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set, i);
        }
    }

    protected void drawDataSet(Canvas c, BarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float space = this.mChart.getBarData().getGroupSpace();
        boolean noStacks = dataSet.getStackSize() == 1;
        ArrayList entries = dataSet.getYVals();
        int j = 0;
        while ((float)j < (float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()) {
            BarEntry e = (BarEntry)entries.get(j);
            float x = (float)(e.getXIndex() + j * (this.mChart.getBarData().getDataSetCount() - 1) + index) + space * (float)j + space / 2.0f;
            float y = e.getVal();
            if (noStacks) {
                this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                if (!this.mViewPortHandler.isInBoundsRight(this.mBarRect.left)) break;
                if (this.mViewPortHandler.isInBoundsLeft(this.mBarRect.right)) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    c.drawRect(this.mBarRect, this.mRenderPaint);
                }
            } else {
                float[] vals = e.getVals();
                if (vals == null) {
                    this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(0));
                    c.drawRect(this.mBarRect, this.mRenderPaint);
                } else {
                    float all = e.getVal();
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        this.prepareBar(x, y, dataSet.getBarSpace(), trans);
                        this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                        c.drawRect(this.mBarShadow, this.mRenderPaint);
                    }
                    for (int k = 0; k < vals.length; ++k) {
                        this.prepareBar(x, vals[k] + (all -= vals[k]), dataSet.getBarSpace(), trans);
                        this.mRenderPaint.setColor(dataSet.getColor(k));
                        c.drawRect(this.mBarRect, this.mRenderPaint);
                    }
                }
                if (!this.mViewPortHandler.isInBoundsRight(this.mBarRect.left)) break;
            }
            ++j;
        }
    }

    protected void prepareBar(float x, float y, float barspace, Transformer trans) {
        float barWidth = 0.5f;
        float spaceHalf = barspace / 2.0f;
        float left = x - barWidth + spaceHalf;
        float right = x + barWidth - spaceHalf;
        float top = y >= 0.0f ? y : 0.0f;
        float bottom = y <= 0.0f ? y : 0.0f;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixel(this.mBarRect, this.mAnimator.getPhaseY());
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mBarShadow.set(this.mBarRect.left, this.mViewPortHandler.offsetTop(), this.mBarRect.right, this.mViewPortHandler.contentBottom());
        }
    }

    protected void prepareBarHighlight(float x, float y, float barspace, float from, Transformer trans) {
        float barWidth = 0.5f;
        float spaceHalf = barspace / 2.0f;
        float left = x - barWidth + spaceHalf;
        float right = x + barWidth - spaceHalf;
        float top = y >= from ? y : from;
        float bottom = y <= from ? y : from;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixel(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.passesCheck()) {
            ArrayList dataSets = this.mChart.getBarData().getDataSets();
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            posOffset = drawValueAboveBar ? -Utils.convertDpToPixel(5.0f) : (float)Utils.calcTextHeight(this.mValuePaint, "8") * 1.5f;
            negOffset = drawValueAboveBar ? (float)Utils.calcTextHeight(this.mValuePaint, "8") * 1.5f : -Utils.convertDpToPixel(5.0f);
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                int j;
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                ValueFormatter formatter = dataSet.getValueFormatter();
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                ArrayList<BarEntry> entries = dataSet.getYVals();
                float[] valuePoints = this.getTransformedValues(trans, entries, i);
                if (!this.mChart.isDrawValuesForWholeStackEnabled()) {
                    j = 0;
                    while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(valuePoints[j])) {
                        if (this.mViewPortHandler.isInBoundsY(valuePoints[j + 1]) && this.mViewPortHandler.isInBoundsLeft(valuePoints[j])) {
                            float val = entries.get(j / 2).getVal();
                            this.drawValue(c, val, valuePoints[j], valuePoints[j + 1] + (val >= 0.0f ? posOffset : negOffset), formatter);
                        }
                        j += 2;
                    }
                    continue;
                }
                j = 0;
                while ((float)j < (float)(valuePoints.length - 1) * this.mAnimator.getPhaseX()) {
                    BarEntry e = entries.get(j / 2);
                    float[] vals = e.getVals();
                    if (vals == null) {
                        if (!this.mViewPortHandler.isInBoundsRight(valuePoints[j])) continue block0;
                        if (this.mViewPortHandler.isInBoundsY(valuePoints[j + 1]) && this.mViewPortHandler.isInBoundsLeft(valuePoints[j])) {
                            this.drawValue(c, e.getVal(), valuePoints[j], valuePoints[j + 1] + (e.getVal() >= 0.0f ? posOffset : negOffset), formatter);
                        }
                    } else {
                        int k;
                        float[] transformed = new float[vals.length * 2];
                        int cnt = 0;
                        float add = e.getVal();
                        for (k = 0; k < transformed.length; k += 2) {
                            transformed[k + 1] = (vals[cnt] + (add -= vals[cnt])) * this.mAnimator.getPhaseY();
                            ++cnt;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float x = valuePoints[j];
                            float y = transformed[k + 1] + (vals[k / 2] >= 0.0f ? posOffset : negOffset);
                            if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                            if (!this.mViewPortHandler.isInBoundsY(y) || !this.mViewPortHandler.isInBoundsLeft(x)) continue;
                            this.drawValue(c, vals[k / 2], x, y, formatter);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    protected void drawValue(Canvas c, float val, float xPos, float yPos, ValueFormatter formatter) {
        String value = formatter.getFormattedValue(val);
        c.drawText(value, xPos, yPos, this.mValuePaint);
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        int setCount = this.mChart.getBarData().getDataSetCount();
        for (int i = 0; i < indices.length; ++i) {
            BarEntry e;
            Highlight h = indices[i];
            int index = h.getXIndex();
            int dataSetIndex = h.getDataSetIndex();
            BarDataSet set = (BarDataSet)this.mChart.getBarData().getDataSetByIndex(dataSetIndex);
            if (set == null) continue;
            Transformer trans = this.mChart.getTransformer(set.getAxisDependency());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            this.mHighlightPaint.setAlpha(set.getHighLightAlpha());
            if (index >= this.mChart.getBarData().getYValCount() || index < 0 || !((float)index < this.mChart.getXChartMax() * this.mAnimator.getPhaseX() / (float)setCount) || (e = (BarEntry)((BarDataSet)this.mChart.getBarData().getDataSetByIndex(dataSetIndex)).getEntryForXIndex(index)) == null) continue;
            float groupspace = this.mChart.getBarData().getGroupSpace();
            boolean isStack = h.getStackIndex() >= 0;
            float x = (float)(index * setCount + dataSetIndex) + groupspace / 2.0f + groupspace * (float)index;
            float y = isStack ? e.getVals()[h.getStackIndex()] + e.getBelowSum(h.getStackIndex()) : e.getVal();
            float from = isStack ? e.getBelowSum(h.getStackIndex()) : 0.0f;
            this.prepareBarHighlight(x, y, set.getBarSpace(), from, trans);
            c.drawRect(this.mBarRect, this.mHighlightPaint);
            if (!this.mChart.isDrawHighlightArrowEnabled()) continue;
            this.mHighlightPaint.setAlpha(255);
            float offsetY = this.mAnimator.getPhaseY() * 0.07f;
            Path arrow = new Path();
            arrow.moveTo(x + 0.5f, y + offsetY * 0.3f);
            arrow.lineTo(x + 0.2f, y + offsetY);
            arrow.lineTo(x + 0.8f, y + offsetY);
            trans.pathValueToPixel(arrow);
            c.drawPath(arrow, this.mHighlightPaint);
        }
    }

    public float[] getTransformedValues(Transformer trans, ArrayList<BarEntry> entries, int dataSetIndex) {
        return trans.generateTransformedValuesBarChart(entries, dataSetIndex, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX();
    }
}

