/*
 * Decompiled with CFR 0.152.
 */
package com.philjay.jwt;

import com.philjay.jwt.Base64Decoder;
import com.philjay.jwt.Base64Encoder;
import com.philjay.jwt.JWKObject;
import com.philjay.jwt.JWTAuthHeader;
import com.philjay.jwt.JWTAuthPayload;
import com.philjay.jwt.JWTToken;
import com.philjay.jwt.JsonDecoder;
import com.philjay.jwt.JsonEncoder;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0018\u00010\n\"\b\b\u0000\u0010\u000b*\u00020\r\"\b\b\u0001\u0010\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J0\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Je\u0010\u001b\u001a\u00020\u0004\"\b\b\u0000\u0010\u000b*\u00020\r\"\b\b\u0001\u0010\f*\u00020\u000e2\u0006\u0010\u001c\u001a\u0002H\u000b2\u0006\u0010\u001d\u001a\u0002H\f2\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010 JL\u0010\u001b\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/philjay/jwt/JWT;", "", "()V", "keyAlgorithm", "", "tokenDelimiter", "", "tokenSignatureAlgorithm", "verifyAlgorithm", "decode", "Lcom/philjay/jwt/JWTToken;", "H", "P", "Lcom/philjay/jwt/JWTAuthHeader;", "Lcom/philjay/jwt/JWTAuthPayload;", "jwtTokenString", "jsonDecoder", "Lcom/philjay/jwt/JsonDecoder;", "decoder", "Lcom/philjay/jwt/Base64Decoder;", "charset", "Ljava/nio/charset/Charset;", "es256", "secret", "data", "encoder", "Lcom/philjay/jwt/Base64Encoder;", "token", "header", "payload", "jsonEncoder", "Lcom/philjay/jwt/JsonEncoder;", "(Lcom/philjay/jwt/JWTAuthHeader;Lcom/philjay/jwt/JWTAuthPayload;Ljava/lang/String;Lcom/philjay/jwt/JsonEncoder;Lcom/philjay/jwt/Base64Encoder;Lcom/philjay/jwt/Base64Decoder;Ljava/nio/charset/Charset;)Ljava/lang/String;", "teamId", "keyId", "verify", "", "jwt", "jwk", "Lcom/philjay/jwt/JWKObject;"})
public final class JWT {
    private static final String verifyAlgorithm = "SHA256withRSA";
    private static final String tokenSignatureAlgorithm = "SHA256withECDSA";
    private static final String keyAlgorithm = "EC";
    private static final char tokenDelimiter = '.';
    public static final JWT INSTANCE;

    @NotNull
    public final String token(@NotNull String teamId, @NotNull String keyId, @NotNull String secret, @NotNull JsonEncoder<JWTAuthHeader, JWTAuthPayload> jsonEncoder, @NotNull Base64Encoder encoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)keyId, (String)"keyId");
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull(jsonEncoder, (String)"jsonEncoder");
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
        long now = instant.getEpochSecond();
        JWTAuthHeader header = new JWTAuthHeader(null, keyId, 1, null);
        JWTAuthPayload payload = new JWTAuthPayload(teamId, now);
        return this.token(header, payload, secret, jsonEncoder, encoder, decoder, charset);
    }

    @NotNull
    public static /* synthetic */ String token$default(JWT jWT, String string, String string2, String string3, JsonEncoder jsonEncoder, Base64Encoder base64Encoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 0x40) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.token((JWTAuthHeader)((Object)string), (JWTAuthPayload)((Object)string2), string3, (JsonEncoder)jsonEncoder, base64Encoder, base64Decoder, charset);
    }

    @NotNull
    public final <H extends JWTAuthHeader, P extends JWTAuthPayload> String token(@NotNull H header, @NotNull P payload, @NotNull String secret, @NotNull JsonEncoder<H, P> jsonEncoder, @NotNull Base64Encoder encoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull(header, (String)"header");
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull(jsonEncoder, (String)"jsonEncoder");
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String headerString = jsonEncoder.toJson(header);
        String payloadString = jsonEncoder.toJson((H)((Object)payload));
        String string = headerString;
        Base64Encoder base64Encoder = encoder;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String base64Header = base64Encoder.encodeURLSafe(byArray2);
        String string3 = payloadString;
        base64Encoder = encoder;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        String base64Payload = base64Encoder.encodeURLSafe(byArray2);
        String value = base64Header + '.' + base64Payload;
        return value + '.' + this.es256(secret, value, encoder, decoder, charset);
    }

    @NotNull
    public static /* synthetic */ String token$default(JWT jWT, JWTAuthHeader jWTAuthHeader, JWTAuthPayload jWTAuthPayload, String string, JsonEncoder jsonEncoder, Base64Encoder base64Encoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 0x40) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.token(jWTAuthHeader, jWTAuthPayload, string, jsonEncoder, base64Encoder, base64Decoder, charset);
    }

    @Nullable
    public final <H extends JWTAuthHeader, P extends JWTAuthPayload> JWTToken<H, P> decode(@NotNull String jwtTokenString, @NotNull JsonDecoder<H, P> jsonDecoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        JWTToken<H, P> jWTToken;
        Intrinsics.checkParameterIsNotNull((Object)jwtTokenString, (String)"jwtTokenString");
        Intrinsics.checkParameterIsNotNull(jsonDecoder, (String)"jsonDecoder");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        List parts = StringsKt.split$default((CharSequence)jwtTokenString, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() >= 2) {
            Object object = (String)parts.get(0);
            Base64Decoder base64Decoder = decoder;
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            object = base64Decoder.decode(byArray2);
            bl = false;
            boolean bl2 = false;
            String headerJson = new String((byte[])object, charset);
            Object object2 = (String)parts.get(1);
            base64Decoder = decoder;
            bl2 = false;
            String string2 = object2;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray2 = byArray3;
            object2 = base64Decoder.decode(byArray2);
            bl2 = false;
            boolean bl3 = false;
            String payloadJson = new String((byte[])object2, charset);
            H header = jsonDecoder.headerFrom(headerJson);
            P payload = jsonDecoder.payloadFrom(payloadJson);
            if (parts.size() == 3) {
                String string3 = (String)parts.get(2);
                base64Decoder = decoder;
                boolean bl4 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray4 = string4.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
                byArray2 = byArray4;
                byte[] signature = base64Decoder.decode(byArray2);
                jWTToken = new JWTToken<H, P>(header, payload, signature);
            } else {
                jWTToken = new JWTToken<H, P>((JWTAuthHeader)header, (JWTAuthPayload)payload, null, 4, null);
            }
        } else {
            jWTToken = null;
        }
        return jWTToken;
    }

    @Nullable
    public static /* synthetic */ JWTToken decode$default(JWT jWT, String string, JsonDecoder jsonDecoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.decode(string, jsonDecoder, base64Decoder, charset);
    }

    public final boolean verify(@NotNull String jwt, @NotNull JWKObject jwk, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)jwt, (String)"jwt");
        Intrinsics.checkParameterIsNotNull((Object)jwk, (String)"jwk");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        PublicKey rsa = jwk.toRSA(decoder);
        if (rsa == null) {
            bl = false;
        } else {
            List parts = StringsKt.split$default((CharSequence)jwt, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 3) {
                String string = (String)parts.get(0);
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] header = byArray;
                String string3 = (String)parts.get(1);
                boolean bl3 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string4.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] payload = byArray2;
                byte[] tokenSignature = decoder.decode((String)parts.get(2));
                Signature rsaSignature = Signature.getInstance(verifyAlgorithm);
                rsaSignature.initVerify(rsa);
                rsaSignature.update(header);
                rsaSignature.update((byte)46);
                rsaSignature.update(payload);
                bl = rsaSignature.verify(tokenSignature);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean verify$default(JWT jWT, String string, JWKObject jWKObject, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.verify(string, jWKObject, base64Decoder, charset);
    }

    private final String es256(String secret, String data, Base64Encoder encoder, Base64Decoder decoder, Charset charset) {
        KeyFactory factory = KeyFactory.getInstance(keyAlgorithm);
        String string = secret;
        Base64Decoder base64Decoder = decoder;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = base64Decoder.decode(byArray2);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(byArray3);
        PrivateKey key = factory.generatePrivate(keySpec);
        Signature algECDSAsha256 = Signature.getInstance(tokenSignatureAlgorithm);
        algECDSAsha256.initSign(key);
        String string3 = data;
        Signature signature = algECDSAsha256;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray4 = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray5 = byArray4;
        signature.update(byArray5);
        byte[] byArray6 = algECDSAsha256.sign();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray6, (String)"algECDSAsha256.sign()");
        return encoder.encodeURLSafe(byArray6);
    }

    private JWT() {
    }

    static {
        JWT jWT;
        INSTANCE = jWT = new JWT();
    }
}

