/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner.core.internal.util;

import com.android.apksigner.core.util.DataSink;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class ByteArrayOutputStreamSink
implements DataSink {
    private final ByteArrayOutputStream mBuf = new ByteArrayOutputStream();

    @Override
    public void consume(byte[] buf, int offset, int length) {
        this.mBuf.write(buf, offset, length);
    }

    @Override
    public void consume(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return;
        }
        if (buf.hasArray()) {
            this.mBuf.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            buf.position(buf.limit());
        } else {
            byte[] tmp = new byte[buf.remaining()];
            buf.get(tmp);
            this.mBuf.write(tmp, 0, tmp.length);
        }
    }

    public byte[] getData() {
        return this.mBuf.toByteArray();
    }
}

