/*
 * Decompiled with CFR 0.152.
 */
package com.othings.technologies.bluetooth.bluetoothBond;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.preference.PreferenceManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.MutableLiveData;
import com.othings.technologies.bluetooth.bluetoothBond.BluetoothBondState;
import com.othings.technologies.bluetooth.bluetoothBond.BluetoothMethod;
import java.lang.reflect.Method;

public class BluetoothBond
implements PreferenceManager.OnActivityResultListener {
    private Context context;
    private MutableLiveData<BluetoothBondState> bondDevice;
    private MutableLiveData<BluetoothBondState> unBondDevice;
    private BluetoothDevice bluetoothDevice;
    private BluetoothAdapter bluetoothAdapter;
    private static final int TURN_ON_BLUETOOTH_REQUEST_CODE = 3001;
    private BluetoothMethod bluetoothMethod;
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "android.bluetooth.device.action.PAIRING_REQUEST": {
                    final BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    int pin = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_KEY", 1234);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothBond.this.bluetoothDevice != null && BluetoothBond.this.bluetoothDevice.getBondState() != 12) {
                                BluetoothBondState bluetoothBondState = new BluetoothBondState(device, 10);
                                BluetoothBond.this.cancelBondRequest();
                                BluetoothBond.this.bondDevice.setValue((Object)bluetoothBondState);
                            }
                        }
                    }, 10000L);
                    break;
                }
                case "android.bluetooth.device.action.BOND_STATE_CHANGED": {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                    int prevState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                    if (state == 11) {
                        BluetoothBond.this.bluetoothDevice = bluetoothDevice;
                        BluetoothBond.this.bondDevice.setValue((Object)new BluetoothBondState(bluetoothDevice, 11));
                        break;
                    }
                    if (state == 12) {
                        BluetoothBond.this.bluetoothDevice = bluetoothDevice;
                        BluetoothBond.this.bondDevice.setValue((Object)new BluetoothBondState(bluetoothDevice, 12));
                        break;
                    }
                    if (state != 10) break;
                    BluetoothBond.this.bluetoothDevice = bluetoothDevice;
                    BluetoothBond.this.unBondDevice.setValue((Object)new BluetoothBondState(bluetoothDevice, 10));
                    break;
                }
            }
        }
    };

    public BluetoothBond(Context context) {
        this.bondDevice = new MutableLiveData();
        this.unBondDevice = new MutableLiveData();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST");
        context.registerReceiver(this.broadcastReceiver, filter);
        filter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        context.registerReceiver(this.broadcastReceiver, filter);
        filter = new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST");
        context.registerReceiver(this.broadcastReceiver, filter);
    }

    public MutableLiveData<BluetoothBondState> bondDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevice = bluetoothDevice;
        this.bluetoothMethod = BluetoothMethod.BOND;
        if (this.bluetoothAdapter.isEnabled()) {
            bluetoothDevice.createBond();
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3001);
        }
        return this.bondDevice;
    }

    public MutableLiveData<BluetoothBondState> unBondDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevice = bluetoothDevice;
        this.bluetoothMethod = BluetoothMethod.UNBOND;
        if (this.bluetoothAdapter.isEnabled()) {
            try {
                Method method = bluetoothDevice.getClass().getMethod("removeBond", null);
                method.invoke((Object)bluetoothDevice, (Object[])null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3001);
        }
        return this.unBondDevice;
    }

    private void cancelBondRequest() {
        this.broadcastReceiver.abortBroadcast();
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 3001) {
            if (this.bluetoothAdapter.isEnabled()) {
                switch (this.bluetoothMethod) {
                    case BOND: {
                        this.bondDevice(this.bluetoothDevice);
                        break;
                    }
                    case UNBOND: {
                        this.unBondDevice(this.bluetoothDevice);
                    }
                }
            } else {
                Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3001);
            }
        }
        return false;
    }
}

