/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.Log;
import com.jakewharton.disklrucache.DiskLruCache;
import com.othershe.combinebitmap.cache.DiskLruCacheHelper;
import com.othershe.combinebitmap.cache.LruCacheHelper;
import com.othershe.combinebitmap.helper.CompressHelper;
import com.othershe.combinebitmap.helper.ThreadPool;
import com.othershe.combinebitmap.helper.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitmapLoader {
    private static String TAG = BitmapLoader.class.getSimpleName();
    private static final int BUFFER_SIZE = 8192;
    private LruCacheHelper lruCacheHelper;
    private DiskLruCache mDiskLruCache;
    private CompressHelper compressHelper;
    private static volatile BitmapLoader manager;
    private Map<String, Runnable> doingTasks;
    private Map<String, List<Runnable>> undoTasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BitmapLoader getInstance(Context context) {
        if (manager != null) return manager;
        Class<BitmapLoader> clazz = BitmapLoader.class;
        synchronized (BitmapLoader.class) {
            if (manager != null) return manager;
            manager = new BitmapLoader(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    private BitmapLoader(Context context) {
        this.mDiskLruCache = new DiskLruCacheHelper((Context)context).mDiskLruCache;
        this.lruCacheHelper = new LruCacheHelper();
        this.compressHelper = CompressHelper.getInstance();
        this.doingTasks = new HashMap<String, Runnable>();
        this.undoTasks = new HashMap<String, List<Runnable>>();
    }

    public void asyncLoad(final int index, final String url, final int reqWidth, final int reqHeight, final Handler handler) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = BitmapLoader.this.loadBitmap(url, reqWidth, reqHeight);
                if (bitmap != null) {
                    handler.obtainMessage(1, index, -1, (Object)bitmap).sendToTarget();
                } else {
                    handler.obtainMessage(2, index, -1, null).sendToTarget();
                }
            }
        };
        if (this.collectUndoTasks(url, task)) {
            return;
        }
        ThreadPool.getInstance().getThreadPoolExecutor().execute(task);
    }

    private Bitmap loadBitmap(String url, int reqWidth, int reqHeight) {
        String key = Utils.hashKeyFormUrl(url);
        Bitmap bitmap = this.lruCacheHelper.getBitmapFromMemCache(key);
        if (bitmap != null) {
            Log.e((String)TAG, (String)("load from memory:" + url));
            return bitmap;
        }
        try {
            bitmap = this.loadBitmapFromDiskCache(url, reqWidth, reqHeight);
            if (bitmap != null) {
                Log.e((String)TAG, (String)("load from disk:" + url));
                return bitmap;
            }
            bitmap = this.loadBitmapFromHttp(url, reqWidth, reqHeight);
            if (bitmap != null) {
                Log.e((String)TAG, (String)("load from http:" + url));
                return bitmap;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Bitmap loadBitmapFromHttp(String url, int reqWidth, int reqHeight) throws IOException {
        String key = Utils.hashKeyFormUrl(url);
        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
        if (editor != null) {
            OutputStream outputStream = editor.newOutputStream(0);
            if (this.downloadUrlToStream(url, outputStream)) {
                editor.commit();
            } else {
                editor.abort();
            }
            this.mDiskLruCache.flush();
            this.executeUndoTasks(url);
        }
        return this.loadBitmapFromDiskCache(url, reqWidth, reqHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean downloadUrlToStream(String urlString, OutputStream outputStream) {
        boolean bl;
        BufferedInputStream in;
        BufferedOutputStream out;
        block6: {
            HttpURLConnection urlConnection = null;
            out = null;
            in = null;
            try {
                int b;
                URL url = new URL(urlString);
                urlConnection = (HttpURLConnection)url.openConnection();
                in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
                out = new BufferedOutputStream(outputStream, 8192);
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                bl = true;
                if (urlConnection == null) break block6;
                urlConnection.disconnect();
            }
            catch (IOException e) {
                block7: {
                    try {
                        Log.e((String)TAG, (String)("downloadBitmap failed." + e));
                        if (urlConnection == null) break block7;
                        urlConnection.disconnect();
                    }
                    catch (Throwable throwable) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        Utils.close(out);
                        Utils.close(in);
                        throw throwable;
                    }
                }
                Utils.close(out);
                Utils.close(in);
                return false;
            }
        }
        Utils.close(out);
        Utils.close(in);
        return bl;
    }

    private Bitmap loadBitmapFromDiskCache(String url, int reqWidth, int reqHeight) throws IOException {
        FileInputStream fileInputStream;
        FileDescriptor fileDescriptor;
        Bitmap bitmap = null;
        String key = Utils.hashKeyFormUrl(url);
        DiskLruCache.Snapshot snapShot = this.mDiskLruCache.get(key);
        if (snapShot != null && (bitmap = this.compressHelper.compressDescriptor(fileDescriptor = (fileInputStream = (FileInputStream)snapShot.getInputStream(0)).getFD(), reqWidth, reqHeight)) != null) {
            this.lruCacheHelper.addBitmapToMemoryCache(key, bitmap);
        }
        return bitmap;
    }

    private boolean collectUndoTasks(String url, Runnable task) {
        String key = Utils.hashKeyFormUrl(url);
        if (this.lruCacheHelper.getBitmapFromMemCache(key) != null) {
            return false;
        }
        DiskLruCache.Snapshot snapShot = null;
        try {
            snapShot = this.mDiskLruCache.get(key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (snapShot != null) {
            return false;
        }
        if (this.doingTasks.containsKey(key)) {
            if (this.undoTasks.containsKey(key)) {
                List<Runnable> tasks = this.undoTasks.get(key);
                tasks.add(task);
                this.undoTasks.put(key, tasks);
            } else {
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                tasks.add(task);
                this.undoTasks.put(key, tasks);
            }
            return true;
        }
        this.doingTasks.put(key, task);
        return false;
    }

    private void executeUndoTasks(String url) {
        String key = Utils.hashKeyFormUrl(url);
        if (this.undoTasks.containsKey(key)) {
            for (Runnable task : this.undoTasks.get(key)) {
                ThreadPool.getInstance().getThreadPoolExecutor().execute(task);
            }
            this.undoTasks.remove(key);
        }
        this.doingTasks.remove(key);
    }
}

