/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.cache;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import com.jakewharton.disklrucache.DiskLruCache;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheHelper {
    private long DISK_CACHE_SIZE = 0x3200000L;
    private String CACHE_DIR = "bitmap_cache";
    public DiskLruCache mDiskLruCache;

    public DiskLruCacheHelper(Context context) {
        File diskCacheDir = this.getDiskCacheDir(context);
        if (!diskCacheDir.exists()) {
            diskCacheDir.mkdirs();
        }
        if (this.getUsableSpace(diskCacheDir) > this.DISK_CACHE_SIZE) {
            try {
                this.mDiskLruCache = DiskLruCache.open((File)diskCacheDir, (int)1, (int)1, (long)this.DISK_CACHE_SIZE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getDiskCacheDir(Context context) {
        boolean externalStorageAvailable = Environment.getExternalStorageState().equals("mounted");
        String cachePath = externalStorageAvailable ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + this.CACHE_DIR);
    }

    private long getUsableSpace(File path) {
        if (Build.VERSION.SDK_INT >= 9) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }
}

