/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.iceberg.Schema;
import com.netflix.iceberg.types.AssignFreshIds;
import com.netflix.iceberg.types.FindTypeVisitor;
import com.netflix.iceberg.types.GetProjectedIds;
import com.netflix.iceberg.types.IndexById;
import com.netflix.iceberg.types.IndexByName;
import com.netflix.iceberg.types.PruneColumns;
import com.netflix.iceberg.types.ReassignIds;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TypeUtil {
    private static int[] MAX_PRECISION = new int[24];
    private static int[] REQUIRED_LENGTH = new int[40];

    public static Schema select(Schema schema, Set<Integer> fieldIds) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema cannot be null");
        Preconditions.checkNotNull(fieldIds, (Object)"Field ids cannot be null");
        Type result = TypeUtil.visit(schema, new PruneColumns(fieldIds));
        if (schema.asStruct() == result) {
            return schema;
        }
        if (result != null) {
            if (schema.getAliases() != null) {
                return new Schema(result.asNestedType().fields(), schema.getAliases());
            }
            return new Schema(result.asNestedType().fields());
        }
        return new Schema((List<Types.NestedField>)ImmutableList.of(), schema.getAliases());
    }

    public static Set<Integer> getProjectedIds(Schema schema) {
        return TypeUtil.visit(schema, new GetProjectedIds());
    }

    public static Set<Integer> getProjectedIds(Type schema) {
        if (schema.isPrimitiveType()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)TypeUtil.visit(schema, new GetProjectedIds()));
    }

    public static Schema selectNot(Schema schema, Set<Integer> fieldIds) {
        Set<Integer> projectedIds = TypeUtil.getProjectedIds(schema);
        projectedIds.removeAll(fieldIds);
        return TypeUtil.select(schema, projectedIds);
    }

    public static Schema join(Schema left, Schema right) {
        ArrayList joinedColumns = Lists.newArrayList();
        joinedColumns.addAll(left.columns());
        joinedColumns.addAll(right.columns());
        return new Schema(joinedColumns);
    }

    public static Map<String, Integer> indexByName(Types.StructType struct) {
        return TypeUtil.visit((Type)struct, new IndexByName());
    }

    public static Map<Integer, Types.NestedField> indexById(Types.StructType struct) {
        return TypeUtil.visit((Type)struct, new IndexById());
    }

    public static Type assignFreshIds(Type type, NextID nextId) {
        return TypeUtil.visit(type, new AssignFreshIds(nextId));
    }

    public static Schema assignFreshIds(Schema schema, NextID nextId) {
        return new Schema(TypeUtil.visit((Type)schema.asStruct(), new AssignFreshIds(nextId)).asNestedType().fields());
    }

    public static Schema reassignIds(Schema schema, Schema idSourceSchema) {
        Types.StructType struct = TypeUtil.visit(schema, new ReassignIds(idSourceSchema)).asStructType();
        return new Schema(struct.fields());
    }

    public static Type find(Schema schema, Predicate<Type> predicate) {
        return TypeUtil.visit(schema, new FindTypeVisitor(predicate));
    }

    public static boolean isPromotionAllowed(Type from, Type.PrimitiveType to) {
        if (from.equals(to)) {
            return true;
        }
        switch (from.typeId()) {
            case INTEGER: {
                return to == Types.LongType.get();
            }
            case FLOAT: {
                return to == Types.DoubleType.get();
            }
            case DECIMAL: {
                Types.DecimalType fromDecimal = (Types.DecimalType)from;
                if (to.typeId() != Type.TypeID.DECIMAL) {
                    return false;
                }
                Types.DecimalType toDecimal = (Types.DecimalType)to;
                return fromDecimal.scale() == toDecimal.scale() && fromDecimal.precision() <= toDecimal.precision();
            }
        }
        return false;
    }

    public static <T> T visit(Schema schema, SchemaVisitor<T> visitor) {
        return visitor.schema(schema, TypeUtil.visit((Type)schema.asStruct(), visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(Type type, SchemaVisitor<T> visitor) {
        switch (type.typeId()) {
            case STRUCT: {
                Types.StructType struct = type.asNestedType().asStructType();
                ArrayList results = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
                for (Types.NestedField field : struct.fields()) {
                    T result;
                    visitor.fieldIds.push(field.fieldId());
                    visitor.fieldNames.push(field.name());
                    try {
                        result = TypeUtil.visit(field.type(), visitor);
                    }
                    finally {
                        visitor.fieldIds.pop();
                        visitor.fieldNames.pop();
                    }
                    results.add(visitor.field(field, result));
                }
                return visitor.struct(struct, results);
            }
            case LIST: {
                T elementResult;
                Types.ListType list = type.asNestedType().asListType();
                visitor.fieldIds.push(list.elementId());
                try {
                    elementResult = TypeUtil.visit(list.elementType(), visitor);
                }
                finally {
                    visitor.fieldIds.pop();
                }
                return visitor.list(list, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                Types.MapType map = type.asNestedType().asMapType();
                visitor.fieldIds.push(map.keyId());
                try {
                    keyResult = TypeUtil.visit(map.keyType(), visitor);
                }
                finally {
                    visitor.fieldIds.pop();
                }
                visitor.fieldIds.push(map.valueId());
                try {
                    valueResult = TypeUtil.visit(map.valueType(), visitor);
                }
                finally {
                    visitor.fieldIds.pop();
                }
                return visitor.map(map, keyResult, valueResult);
            }
        }
        return visitor.primitive(type.asPrimitiveType());
    }

    public static <T> T visit(Schema schema, CustomOrderSchemaVisitor<T> visitor) {
        return visitor.schema(schema, new VisitFuture(schema.asStruct(), visitor));
    }

    public static <T> T visit(Type type, CustomOrderSchemaVisitor<T> visitor) {
        switch (type.typeId()) {
            case STRUCT: {
                Types.StructType struct = type.asNestedType().asStructType();
                ArrayList results = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
                for (Types.NestedField field : struct.fields()) {
                    results.add(new VisitFieldFuture(field, visitor));
                }
                return visitor.struct(struct, Iterables.transform((Iterable)results, VisitFieldFuture::get));
            }
            case LIST: {
                Types.ListType list = type.asNestedType().asListType();
                return visitor.list(list, new VisitFuture(list.elementType(), visitor));
            }
            case MAP: {
                Types.MapType map = type.asNestedType().asMapType();
                return visitor.map(map, new VisitFuture(map.keyType(), visitor), new VisitFuture(map.valueType(), visitor));
            }
        }
        return visitor.primitive(type.asPrimitiveType());
    }

    static int decimalMaxPrecision(int numBytes) {
        Preconditions.checkArgument((numBytes >= 0 && numBytes < 24 ? 1 : 0) != 0, (Object)("Unsupported decimal length: " + numBytes));
        return MAX_PRECISION[numBytes];
    }

    public static int decimalRequriedBytes(int precision) {
        Preconditions.checkArgument((precision >= 0 && precision < 40 ? 1 : 0) != 0, (Object)("Unsupported decimal precision: " + precision));
        return REQUIRED_LENGTH[precision];
    }

    static {
        for (int len = 0; len < MAX_PRECISION.length; ++len) {
            TypeUtil.MAX_PRECISION[len] = (int)Math.floor(Math.log10(Math.pow(2.0, 8 * len - 1) - 1.0));
        }
        for (int precision = 0; precision < REQUIRED_LENGTH.length; ++precision) {
            TypeUtil.REQUIRED_LENGTH[precision] = -1;
            for (int len = 0; len < MAX_PRECISION.length; ++len) {
                if (precision > MAX_PRECISION[len]) continue;
                TypeUtil.REQUIRED_LENGTH[precision] = len;
                break;
            }
            if (REQUIRED_LENGTH[precision] >= 0) continue;
            throw new IllegalStateException("Could not find required length for precision " + precision);
        }
    }

    private static class VisitFieldFuture<T>
    implements Supplier<T> {
        private final Types.NestedField field;
        private final CustomOrderSchemaVisitor<T> visitor;

        private VisitFieldFuture(Types.NestedField field, CustomOrderSchemaVisitor<T> visitor) {
            this.field = field;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return this.visitor.field(this.field, new VisitFuture(this.field.type(), this.visitor));
        }
    }

    private static class VisitFuture<T>
    implements Supplier<T> {
        private final Type type;
        private final CustomOrderSchemaVisitor<T> visitor;

        private VisitFuture(Type type, CustomOrderSchemaVisitor<T> visitor) {
            this.type = type;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return TypeUtil.visit(this.type, this.visitor);
        }
    }

    public static class CustomOrderSchemaVisitor<T> {
        public T schema(Schema schema, Supplier<T> structResult) {
            return null;
        }

        public T struct(Types.StructType struct, Iterable<T> fieldResults) {
            return null;
        }

        public T field(Types.NestedField field, Supplier<T> fieldResult) {
            return null;
        }

        public T list(Types.ListType list, Supplier<T> elementResult) {
            return null;
        }

        public T map(Types.MapType map, Supplier<T> keyResult, Supplier<T> valueResult) {
            return null;
        }

        public T primitive(Type.PrimitiveType primitive) {
            return null;
        }
    }

    public static class SchemaVisitor<T> {
        protected LinkedList<String> fieldNames = Lists.newLinkedList();
        protected LinkedList<Integer> fieldIds = Lists.newLinkedList();

        public T schema(Schema schema, T structResult) {
            return null;
        }

        public T struct(Types.StructType struct, List<T> fieldResults) {
            return null;
        }

        public T field(Types.NestedField field, T fieldResult) {
            return null;
        }

        public T list(Types.ListType list, T elementResult) {
            return null;
        }

        public T map(Types.MapType map, T keyResult, T valueResult) {
            return null;
        }

        public T primitive(Type.PrimitiveType primitive) {
            return null;
        }
    }

    public static interface NextID {
        public int get();
    }
}

