/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.netflix.iceberg.types.PrimitiveHolder;
import com.netflix.iceberg.types.Types;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

public interface Type
extends Serializable {
    public TypeID typeId();

    default public boolean isPrimitiveType() {
        return false;
    }

    default public PrimitiveType asPrimitiveType() {
        throw new IllegalArgumentException("Not a primitive type: " + this);
    }

    default public Types.StructType asStructType() {
        throw new IllegalArgumentException("Not a struct type: " + this);
    }

    default public Types.ListType asListType() {
        throw new IllegalArgumentException("Not a list type: " + this);
    }

    default public Types.MapType asMapType() {
        throw new IllegalArgumentException("Not a map type: " + this);
    }

    default public boolean isNestedType() {
        return false;
    }

    default public boolean isStructType() {
        return false;
    }

    default public boolean isListType() {
        return false;
    }

    default public boolean isMapType() {
        return false;
    }

    default public NestedType asNestedType() {
        throw new IllegalArgumentException("Not a nested type: " + this);
    }

    public static abstract class NestedType
    implements Type {
        @Override
        public boolean isNestedType() {
            return true;
        }

        @Override
        public NestedType asNestedType() {
            return this;
        }

        public abstract List<Types.NestedField> fields();

        public abstract Type fieldType(String var1);

        public abstract Types.NestedField field(int var1);
    }

    public static abstract class PrimitiveType
    implements Type {
        @Override
        public boolean isPrimitiveType() {
            return true;
        }

        @Override
        public PrimitiveType asPrimitiveType() {
            return this;
        }

        Object writeReplace() throws ObjectStreamException {
            return new PrimitiveHolder(this.toString());
        }
    }

    public static enum TypeID {
        BOOLEAN(Boolean.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        DATE(Integer.class),
        TIME(Long.class),
        TIMESTAMP(Long.class),
        STRING(CharSequence.class),
        UUID(UUID.class),
        FIXED(ByteBuffer.class),
        BINARY(ByteBuffer.class),
        DECIMAL(BigDecimal.class),
        STRUCT(Void.class),
        LIST(Void.class),
        MAP(Void.class);

        private final Class<?> javaClass;

        private TypeID(Class<?> javaClass) {
            this.javaClass = javaClass;
        }

        public Class<?> javaClass() {
            return this.javaClass;
        }
    }
}

