/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.transforms;

import com.google.common.base.Objects;
import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.UnboundPredicate;
import com.netflix.iceberg.transforms.ProjectionUtil;
import com.netflix.iceberg.transforms.Transform;
import com.netflix.iceberg.transforms.TransformUtil;
import com.netflix.iceberg.types.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

abstract class Truncate<T>
implements Transform<T, T> {
    Truncate() {
    }

    static <T> Truncate<T> get(Type type, int width) {
        switch (type.typeId()) {
            case INTEGER: {
                return new TruncateInteger(width);
            }
            case LONG: {
                return new TruncateLong(width);
            }
            case DECIMAL: {
                return new TruncateDecimal(width);
            }
            case STRING: {
                return new TruncateString(width);
            }
            case BINARY: {
                return new TruncateByteBuffer(width);
            }
        }
        throw new UnsupportedOperationException("Cannot truncate type: " + type);
    }

    public abstract Integer width();

    @Override
    public abstract T apply(T var1);

    @Override
    public Type getResultType(Type sourceType) {
        return sourceType;
    }

    private static class TruncateDecimal
    extends Truncate<BigDecimal> {
        private final BigInteger unscaledWidth;

        private TruncateDecimal(int unscaledWidth) {
            this.unscaledWidth = BigInteger.valueOf(unscaledWidth);
        }

        @Override
        public Integer width() {
            return this.unscaledWidth.intValue();
        }

        @Override
        public BigDecimal apply(BigDecimal value) {
            BigDecimal remainder = new BigDecimal(value.unscaledValue().remainder(this.unscaledWidth).add(this.unscaledWidth).remainder(this.unscaledWidth), value.scale());
            return value.subtract(remainder);
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.DECIMAL;
        }

        @Override
        public UnboundPredicate<BigDecimal> project(String name, BoundPredicate<BigDecimal> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateDecimal(name, pred, this);
        }

        @Override
        public UnboundPredicate<BigDecimal> projectStrict(String name, BoundPredicate<BigDecimal> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateDecimal that = (TruncateDecimal)o;
            return this.unscaledWidth.equals(that.unscaledWidth);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.unscaledWidth});
        }

        public String toString() {
            return "truncate[" + this.unscaledWidth + "]";
        }
    }

    private static class TruncateByteBuffer
    extends Truncate<ByteBuffer> {
        private final int L;

        private TruncateByteBuffer(int length) {
            this.L = length;
        }

        @Override
        public Integer width() {
            return this.L;
        }

        @Override
        public ByteBuffer apply(ByteBuffer value) {
            ByteBuffer ret = value.duplicate();
            ret.limit(Math.min(value.limit(), value.position() + this.L));
            return ret;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.BINARY;
        }

        @Override
        public UnboundPredicate<ByteBuffer> project(String name, BoundPredicate<ByteBuffer> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateArray(name, pred, this);
        }

        @Override
        public UnboundPredicate<ByteBuffer> projectStrict(String name, BoundPredicate<ByteBuffer> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateByteBuffer that = (TruncateByteBuffer)o;
            return this.L == that.L;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.L});
        }

        @Override
        public String toHumanString(ByteBuffer value) {
            return value == null ? "null" : TransformUtil.base64encode(value);
        }

        public String toString() {
            return "truncate[" + this.L + "]";
        }
    }

    private static class TruncateString
    extends Truncate<CharSequence> {
        private final int L;

        private TruncateString(int length) {
            this.L = length;
        }

        @Override
        public Integer width() {
            return this.L;
        }

        @Override
        public CharSequence apply(CharSequence value) {
            return value.subSequence(0, Math.min(value.length(), this.L));
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.STRING;
        }

        @Override
        public UnboundPredicate<CharSequence> project(String name, BoundPredicate<CharSequence> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateArray(name, pred, this);
        }

        @Override
        public UnboundPredicate<CharSequence> projectStrict(String name, BoundPredicate<CharSequence> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateString that = (TruncateString)o;
            return this.L == that.L;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.L});
        }

        public String toString() {
            return "truncate[" + this.L + "]";
        }
    }

    private static class TruncateLong
    extends Truncate<Long> {
        private final int W;

        private TruncateLong(int width) {
            this.W = width;
        }

        @Override
        public Integer width() {
            return this.W;
        }

        @Override
        public Long apply(Long value) {
            return value - (value % (long)this.W + (long)this.W) % (long)this.W;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.LONG;
        }

        @Override
        public UnboundPredicate<Long> project(String name, BoundPredicate<Long> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateLong(name, pred, this);
        }

        @Override
        public UnboundPredicate<Long> projectStrict(String name, BoundPredicate<Long> predicate) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateLong that = (TruncateLong)o;
            return this.W == that.W;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.W});
        }

        public String toString() {
            return "truncate[" + this.W + "]";
        }
    }

    private static class TruncateInteger
    extends Truncate<Integer> {
        private final int W;

        private TruncateInteger(int width) {
            this.W = width;
        }

        @Override
        public Integer width() {
            return this.W;
        }

        @Override
        public Integer apply(Integer value) {
            return value - (value % this.W + this.W) % this.W;
        }

        @Override
        public boolean canTransform(Type type) {
            return type.typeId() == Type.TypeID.INTEGER;
        }

        @Override
        public UnboundPredicate<Integer> project(String name, BoundPredicate<Integer> pred) {
            if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
                return Expressions.predicate(pred.op(), name);
            }
            return ProjectionUtil.truncateInteger(name, pred, this);
        }

        @Override
        public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<Integer> predicate) {
            switch (predicate.op()) {
                case LT: {
                    int in = (Integer)predicate.literal().value() - 1;
                    int out = (Integer)predicate.literal().value();
                    int inImage = this.apply(in);
                    int outImage = this.apply(out);
                    if (inImage != outImage) {
                        return Expressions.predicate(Expression.Operation.LT_EQ, name, inImage);
                    }
                    return Expressions.predicate(Expression.Operation.LT, name, inImage);
                }
                case LT_EQ: {
                    int in = (Integer)predicate.literal().value();
                    int out = (Integer)predicate.literal().value() + 1;
                    int inImage = this.apply(in);
                    int outImage = this.apply(out);
                    if (inImage != outImage) {
                        return Expressions.predicate(Expression.Operation.LT_EQ, name, inImage);
                    }
                    return Expressions.predicate(Expression.Operation.LT, name, inImage);
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateInteger that = (TruncateInteger)o;
            return this.W == that.W;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.W});
        }

        public String toString() {
            return "truncate[" + this.W + "]";
        }
    }
}

