/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.transforms;

import com.google.common.base.Preconditions;
import com.netflix.iceberg.transforms.Bucket;
import com.netflix.iceberg.transforms.Dates;
import com.netflix.iceberg.transforms.Identity;
import com.netflix.iceberg.transforms.Timestamps;
import com.netflix.iceberg.transforms.Transform;
import com.netflix.iceberg.transforms.Truncate;
import com.netflix.iceberg.types.Type;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Transforms {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)\\]");

    private Transforms() {
    }

    public static Transform<?, ?> fromString(Type type, String transform) {
        Matcher width = HAS_WIDTH.matcher(transform);
        if (width.matches()) {
            String name = width.group(1);
            int w = Integer.parseInt(width.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(type, w);
            }
            if (name.equals("bucket")) {
                return Bucket.get(type, w);
            }
        }
        if (transform.equalsIgnoreCase("identity")) {
            return Identity.get(type);
        }
        if (type.typeId() == Type.TypeID.TIMESTAMP) {
            return Timestamps.valueOf(transform.toUpperCase(Locale.ENGLISH));
        }
        if (type.typeId() == Type.TypeID.DATE) {
            return Dates.valueOf(transform.toUpperCase(Locale.ENGLISH));
        }
        throw new IllegalArgumentException("Unknown transform: " + transform);
    }

    public static <T> Transform<T, T> identity(Type type) {
        return Identity.get(type);
    }

    public static <T> Transform<T, Integer> year(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.YEAR;
            }
            case TIMESTAMP: {
                return Timestamps.YEAR;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by year");
    }

    public static <T> Transform<T, Integer> month(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.MONTH;
            }
            case TIMESTAMP: {
                return Timestamps.MONTH;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by month");
    }

    public static <T> Transform<T, Integer> day(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.DAY;
            }
            case TIMESTAMP: {
                return Timestamps.DAY;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by month");
    }

    public static <T> Transform<T, Integer> hour(Type type) {
        Preconditions.checkArgument((type.typeId() == Type.TypeID.TIMESTAMP ? 1 : 0) != 0, (String)"Cannot partition type %s by hour", (Object[])new Object[]{type});
        return Timestamps.HOUR;
    }

    public static <T> Transform<T, Integer> bucket(Type type, int numBuckets) {
        return Bucket.get(type, numBuckets);
    }

    public static <T> Transform<T, T> truncate(Type type, int width) {
        return Truncate.get(type, width);
    }
}

