/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.transforms;

import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.UnboundPredicate;
import com.netflix.iceberg.transforms.ProjectionUtil;
import com.netflix.iceberg.transforms.Transform;
import com.netflix.iceberg.transforms.TransformUtil;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.Types;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

enum Dates implements Transform<Integer, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day");

    private static final OffsetDateTime EPOCH;
    private final ChronoUnit granularity;
    private final String name;

    private Dates(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
    }

    @Override
    public Integer apply(Integer days) {
        if (this.granularity == ChronoUnit.DAYS) {
            return days;
        }
        return (int)this.granularity.between(EPOCH, EPOCH.plusDays(days.intValue()));
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.DATE;
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public UnboundPredicate<Integer> project(String name, BoundPredicate<Integer> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), name);
        }
        return ProjectionUtil.truncateInteger(name, pred, this);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<Integer> predicate) {
        return null;
    }

    @Override
    public String toHumanString(Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
    }

    public String toString() {
        return this.name;
    }

    static {
        EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    }
}

