/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.PartitionField;
import com.netflix.iceberg.PartitionSpec;
import com.netflix.iceberg.StructLike;
import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.expressions.Predicate;
import com.netflix.iceberg.expressions.UnboundPredicate;
import java.io.Serializable;
import java.util.Comparator;

public class ResidualEvaluator
implements Serializable {
    private final PartitionSpec spec;
    private final Expression expr;
    private transient ThreadLocal<ResidualVisitor> visitors = null;

    private ResidualVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new ResidualVisitor());
        }
        return this.visitors.get();
    }

    public ResidualEvaluator(PartitionSpec spec, Expression expr) {
        this.spec = spec;
        this.expr = expr;
    }

    public Expression residualFor(StructLike partitionData) {
        return this.visitor().eval(partitionData);
    }

    private class ResidualVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Expression> {
        private StructLike struct;

        private ResidualVisitor() {
        }

        private Expression eval(StructLike struct) {
            this.struct = struct;
            return ExpressionVisitors.visit(ResidualEvaluator.this.expr, this);
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            return Expressions.not(result);
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression isNull(BoundReference<T> ref) {
            return ref.get(this.struct) == null ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression notNull(BoundReference<T> ref) {
            return ref.get(this.struct) != null ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression lt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) < 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression ltEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) <= 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression gt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) > 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression gtEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) >= 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression eq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) == 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression notEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) != 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            PartitionField part = ResidualEvaluator.this.spec.getFieldBySourceId(((BoundReference)pred.ref()).fieldId());
            if (part == null) {
                return pred;
            }
            UnboundPredicate<?> strictProjection = part.transform().projectStrict(part.name(), pred);
            if (strictProjection != null) {
                Expression bound = strictProjection.bind(ResidualEvaluator.this.spec.partitionType(), true);
                if (bound instanceof BoundPredicate) {
                    return (Expression)super.predicate((BoundPredicate)bound);
                }
                return bound;
            }
            return pred;
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            Expression bound = pred.bind(ResidualEvaluator.this.spec.schema().asStruct(), true);
            if (bound instanceof BoundPredicate) {
                Object boundResidual = this.predicate((BoundPredicate)bound);
                if (boundResidual instanceof Predicate) {
                    return pred;
                }
                return boundResidual;
            }
            return bound;
        }
    }
}

