/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.expressions.And;
import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.expressions.Not;
import com.netflix.iceberg.expressions.Or;
import com.netflix.iceberg.expressions.Predicate;
import com.netflix.iceberg.expressions.UnboundPredicate;

public class ExpressionVisitors {
    public static <R> R visit(Expression expr, ExpressionVisitor<R> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not = (Not)expr;
                return visitor.not(ExpressionVisitors.visit(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                return visitor.and(ExpressionVisitors.visit(and.left(), visitor), ExpressionVisitors.visit(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                return visitor.or(ExpressionVisitors.visit(or.left(), visitor), ExpressionVisitors.visit(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + (Object)((Object)expr.op()));
    }

    public static abstract class BoundExpressionVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R notNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R lt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R eq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R in(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R notIn(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            switch (pred.op()) {
                case IS_NULL: {
                    return this.isNull((BoundReference)pred.ref());
                }
                case NOT_NULL: {
                    return this.notNull((BoundReference)pred.ref());
                }
                case LT: {
                    return this.lt((BoundReference)pred.ref(), pred.literal());
                }
                case LT_EQ: {
                    return this.ltEq((BoundReference)pred.ref(), pred.literal());
                }
                case GT: {
                    return this.gt((BoundReference)pred.ref(), pred.literal());
                }
                case GT_EQ: {
                    return this.gtEq((BoundReference)pred.ref(), pred.literal());
                }
                case EQ: {
                    return this.eq((BoundReference)pred.ref(), pred.literal());
                }
                case NOT_EQ: {
                    return this.notEq((BoundReference)pred.ref(), pred.literal());
                }
                case IN: {
                    return this.in((BoundReference)pred.ref(), pred.literal());
                }
                case NOT_IN: {
                    return this.notIn((BoundReference)pred.ref(), pred.literal());
                }
            }
            throw new UnsupportedOperationException("Unknown operation for predicate: " + (Object)((Object)pred.op()));
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + pred);
        }
    }

    public static abstract class ExpressionVisitor<R> {
        public R alwaysTrue() {
            return null;
        }

        public R alwaysFalse() {
            return null;
        }

        public R not(R result) {
            return null;
        }

        public R and(R leftResult, R rightResult) {
            return null;
        }

        public R or(R leftResult, R rightResult) {
            return null;
        }

        public <T> R predicate(BoundPredicate<T> pred) {
            return null;
        }

        public <T> R predicate(UnboundPredicate<T> pred) {
            return null;
        }
    }
}

