/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.StructLike;
import com.netflix.iceberg.exceptions.ValidationException;
import com.netflix.iceberg.expressions.Reference;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.Types;
import java.util.List;

public class BoundReference<T>
implements Reference {
    private final int fieldId;
    private final Type type;
    private final int pos;

    BoundReference(Types.StructType struct, int fieldId) {
        this.fieldId = fieldId;
        this.pos = this.find(fieldId, struct);
        this.type = struct.fields().get(this.pos).type();
    }

    private int find(int fieldId, Types.StructType struct) {
        List<Types.NestedField> fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).fieldId() != fieldId) continue;
            return i;
        }
        throw new ValidationException("Cannot find top-level field id %d in struct: %s", fieldId, struct);
    }

    public Type type() {
        return this.type;
    }

    public int fieldId() {
        return this.fieldId;
    }

    public int pos() {
        return this.pos;
    }

    public T get(StructLike struct) {
        return struct.get(this.pos, this.javaType());
    }

    public String toString() {
        return String.format("ref(id=%d, pos=%d, type=%s)", this.fieldId, this.pos, this.type);
    }

    private Class<T> javaType() {
        return this.type.asPrimitiveType().typeId().javaClass();
    }
}

