/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.iceberg.events.Listener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Listeners {
    private static final Map<Class<?>, List<Listener<?>>> listeners = Maps.newConcurrentMap();

    private Listeners() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void register(Listener<E> listener, Class<E> eventType) {
        ArrayList list = listeners.get(eventType);
        if (list == null) {
            Map<Class<?>, List<Listener<?>>> map = listeners;
            synchronized (map) {
                list = listeners.get(eventType);
                if (list == null) {
                    list = Lists.newArrayList();
                    listeners.put(eventType, list);
                }
            }
        }
        list.add(listener);
    }

    public static <E> void notifyAll(E event) {
        Preconditions.checkNotNull(event, (Object)"Cannot notify listeners for a null event.");
        List<Listener<?>> list = listeners.get(event.getClass());
        if (list != null) {
            for (Listener<?> listener : list) {
                listener.notify(event);
            }
        }
    }
}

