/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.TypeUtil;
import com.netflix.iceberg.types.Types;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Schema
implements Serializable {
    private static final Joiner NEWLINE = Joiner.on((char)'\n');
    private static final String ALL_COLUMNS = "*";
    private final Types.StructType struct;
    private transient BiMap<String, Integer> aliasToId = null;
    private transient Map<Integer, Types.NestedField> idToField = null;
    private transient BiMap<String, Integer> nameToId = null;

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases) {
        this.struct = Types.StructType.of(columns);
        this.aliasToId = aliases != null ? ImmutableBiMap.copyOf(aliases) : null;
    }

    public Schema(List<Types.NestedField> columns) {
        this.struct = Types.StructType.of(columns);
    }

    private Map<Integer, Types.NestedField> lazyIdToField() {
        if (this.idToField == null) {
            this.idToField = TypeUtil.indexById(this.struct);
        }
        return this.idToField;
    }

    private BiMap<String, Integer> lazyNameToId() {
        if (this.nameToId == null) {
            this.nameToId = ImmutableBiMap.copyOf(TypeUtil.indexByName(this.struct));
        }
        return this.nameToId;
    }

    public Schema(Types.NestedField ... columns) {
        this(Arrays.asList(columns));
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    public Types.StructType asStruct() {
        return this.struct;
    }

    public List<Types.NestedField> columns() {
        return this.struct.fields();
    }

    public Type findType(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        return this.findType((Integer)this.lazyNameToId().get((Object)name));
    }

    public Type findType(int id) {
        Types.NestedField field = this.lazyIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Types.NestedField findField(int id) {
        return this.lazyIdToField().get(id);
    }

    public Types.NestedField findField(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = (Integer)this.lazyNameToId().get((Object)name);
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public String findColumnName(int id) {
        return (String)this.lazyNameToId().inverse().get((Object)id);
    }

    public Integer aliasToId(String alias) {
        if (this.aliasToId != null) {
            return (Integer)this.aliasToId.get((Object)alias);
        }
        return null;
    }

    public String idToAlias(Integer fieldId) {
        if (this.aliasToId != null) {
            return (String)this.aliasToId.inverse().get((Object)fieldId);
        }
        return null;
    }

    public Schema select(String ... names) {
        return this.select(Arrays.asList(names));
    }

    public Schema select(Collection<String> names) {
        if (names.contains(ALL_COLUMNS)) {
            return this;
        }
        HashSet selected = Sets.newHashSet();
        for (String name : names) {
            Integer id = (Integer)this.lazyNameToId().get((Object)name);
            if (id == null) continue;
            selected.add(id);
        }
        return TypeUtil.select(this, selected);
    }

    public String toString() {
        return String.format("table {\n%s\n}", NEWLINE.join((Iterable)this.struct.fields().stream().map(f -> "  " + f + (f.doc() == null ? "" : " COMMENT '" + f.doc() + "'")).collect(Collectors.toList())));
    }
}

