/*
 * Decompiled with CFR 0.152.
 */
package net.nashlegend.anypref;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;
import java.util.Set;

public class SharedPrefs {
    Context context;
    String prefName;
    private SharedPreferences.Editor mEditor;
    private boolean isInTransaction = false;

    public SharedPrefs(String prefName, Context context) {
        this.prefName = prefName;
        this.context = context;
    }

    public int getInt(String key, int def) {
        return this.getSharedPreferences().getInt(key, def);
    }

    public long getLong(String key, long def) {
        return this.getSharedPreferences().getLong(key, def);
    }

    public float getFloat(String key, float def) {
        return this.getSharedPreferences().getFloat(key, def);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.getSharedPreferences().getBoolean(key, def);
    }

    public String getString(String key, String def) {
        return this.getSharedPreferences().getString(key, def);
    }

    public Set<String> getStringSet(String key, Set<String> def) {
        return this.getSharedPreferences().getStringSet(key, def);
    }

    public Map<String, ?> getAll() {
        return this.getSharedPreferences().getAll();
    }

    public SharedPrefs putInt(String key, int value) {
        this.wrap(this.getEditor().putInt(key, value));
        return this;
    }

    public SharedPrefs putLong(String key, long value) {
        this.wrap(this.getEditor().putLong(key, value));
        return this;
    }

    public SharedPrefs putFloat(String key, float value) {
        this.wrap(this.getEditor().putFloat(key, value));
        return this;
    }

    public SharedPrefs putBoolean(String key, boolean value) {
        this.wrap(this.getEditor().putBoolean(key, value));
        return this;
    }

    public SharedPrefs putString(String key, String value) {
        this.wrap(this.getEditor().putString(key, value));
        return this;
    }

    public SharedPrefs putStringSet(String key, Set<String> value) {
        this.wrap(this.getEditor().putStringSet(key, value));
        return this;
    }

    public SharedPrefs remove(String key) {
        this.wrap(this.getEditor().remove(key));
        return this;
    }

    public SharedPrefs clear() {
        this.wrap(this.getEditor().clear());
        return this;
    }

    public boolean contains(String key) {
        return this.getSharedPreferences().contains(key);
    }

    public void commit() {
        this.getEditor().commit();
        this.isInTransaction = false;
    }

    public void apply() {
        this.getEditor().apply();
        this.isInTransaction = false;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.getSharedPreferences().registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.getSharedPreferences().unregisterOnSharedPreferenceChangeListener(listener);
    }

    public SharedPrefs beginTransaction() {
        this.isInTransaction = true;
        return this;
    }

    private void wrap(SharedPreferences.Editor editor) {
        if (!this.isInTransaction) {
            editor.apply();
        }
    }

    public SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(this.prefName, 0);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public SharedPreferences.Editor getEditor() {
        if (this.mEditor == null) {
            this.mEditor = this.getSharedPreferences().edit();
        }
        return this.mEditor;
    }
}

