/*
 * Decompiled with CFR 0.152.
 */
package net.nashlegend.anypref;

import android.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.nashlegend.anypref.AnyPref;
import net.nashlegend.anypref.annotations.PrefArrayList;
import net.nashlegend.anypref.annotations.PrefField;
import net.nashlegend.anypref.annotations.PrefIgnore;
import net.nashlegend.anypref.annotations.PrefModel;
import net.nashlegend.anypref.annotations.PrefSub;

public class PrefUtil {
    private static ConcurrentHashMap<String, Class> arraylistType = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ArrayList<Field>> fieldsMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> strSetMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> classKeyMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> fieldKeyMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Double> defaultNumberMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> defaultBooleanMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> defaultStringMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<String>> defaultStringSetMap = new ConcurrentHashMap();

    public static boolean isFieldStringSet(Field field) {
        String mapKey = PrefUtil.getCacheKeyForField(field);
        Boolean result = strSetMap.get(mapKey);
        if (result == null) {
            boolean isSet = PrefUtil.checkIsFieldStringSet(field);
            strSetMap.put(mapKey, isSet);
            return isSet;
        }
        return result;
    }

    public static boolean checkIsFieldStringSet(Field field) {
        Class genericClazz;
        ParameterizedType pt;
        Type[] types;
        Type tp;
        return field.getType().isAssignableFrom(Set.class) && (tp = field.getGenericType()) != null && tp instanceof ParameterizedType && (types = (pt = (ParameterizedType)tp).getActualTypeArguments()).length == 1 && (genericClazz = (Class)pt.getActualTypeArguments()[0]).getCanonicalName().equals(String.class.getCanonicalName());
    }

    public static boolean isSubPref(Field field) {
        return field.isAnnotationPresent(PrefSub.class);
    }

    public static boolean isArrayListPref(Field field) {
        return field.isAnnotationPresent(PrefArrayList.class);
    }

    public static String getPrefNameForClass(Class clazz) {
        String key = classKeyMap.get(clazz.getCanonicalName());
        if (key == null) {
            PrefModel model;
            String value;
            if (clazz.isAnnotationPresent(PrefModel.class) && !TextUtils.isEmpty((CharSequence)(value = (model = clazz.getAnnotation(PrefModel.class)).value()))) {
                classKeyMap.put(clazz.getCanonicalName(), value);
                return value;
            }
            classKeyMap.put(clazz.getCanonicalName(), clazz.getCanonicalName());
            return clazz.getCanonicalName();
        }
        return key;
    }

    public static String getKeyForField(Field field) {
        String cacheKey = PrefUtil.getCacheKeyForField(field);
        String key = fieldKeyMap.get(cacheKey);
        if (key == null) {
            PrefField pref;
            String value;
            if (field.isAnnotationPresent(PrefField.class) && !TextUtils.isEmpty((CharSequence)(value = (pref = field.getAnnotation(PrefField.class)).value()))) {
                fieldKeyMap.put(cacheKey, value);
                return value;
            }
            fieldKeyMap.put(cacheKey, field.getName());
            return field.getName();
        }
        return key;
    }

    public static boolean isFieldIgnored(Field field) {
        return field.isAnnotationPresent(PrefIgnore.class);
    }

    public static ArrayList<Field> getFields(Class clazz) {
        String key = PrefUtil.getPrefNameForClass(clazz);
        ArrayList<Field> fields = fieldsMap.get(key);
        if (fields == null) {
            Field[] fieldArray;
            fields = new ArrayList();
            for (Field field : fieldArray = clazz.getFields()) {
                int modifier = field.getModifiers();
                if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier) || PrefUtil.isFieldIgnored(field)) continue;
                PrefUtil.getDefaultValue(field);
                fields.add(field);
            }
            fieldsMap.put(key, fields);
        }
        return fields;
    }

    public static void getDefaultValue(Field field) {
        if (field.isAnnotationPresent(PrefField.class)) {
            String type;
            PrefField pref = field.getAnnotation(PrefField.class);
            String cacheKey = PrefUtil.getCacheKeyForField(field);
            switch (type = field.getType().getCanonicalName()) {
                case "int": 
                case "float": 
                case "long": {
                    defaultNumberMap.put(cacheKey, pref.numDef());
                    break;
                }
                case "boolean": {
                    defaultBooleanMap.put(cacheKey, pref.boolDef());
                    break;
                }
                case "java.lang.String": {
                    String[] ds = pref.strDef();
                    if (ds == null || ds.length <= 0) break;
                    defaultStringMap.put(cacheKey, pref.strDef()[0]);
                    break;
                }
                default: {
                    String[] sets;
                    if (!PrefUtil.isFieldStringSet(field) || (sets = pref.strDef()) == null) break;
                    LinkedHashSet<String> hashSet = new LinkedHashSet<String>();
                    hashSet.addAll(Arrays.asList(pref.strDef()));
                    defaultStringSetMap.put(cacheKey, hashSet);
                }
            }
        }
    }

    public static String getCacheKeyForField(Field field) {
        return field.getDeclaringClass().getCanonicalName() + "$$" + field.getName();
    }

    public static double getDefaultNumber(String key) {
        Double num = defaultNumberMap.get(key);
        if (num == null) {
            return 0.0;
        }
        return num;
    }

    public static boolean getDefaultBoolean(String key) {
        Boolean bool = defaultBooleanMap.get(key);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public static String getDefaultString(String key) {
        return defaultStringMap.get(key);
    }

    public static Set<String> getDefaultStringSet(String key) {
        return defaultStringSetMap.get(key);
    }

    public static ArrayList<String> getArrayListKeys(Field field, String prefKey) {
        String lengthKey = PrefUtil.getArrayListLengthKey(field, prefKey);
        int length = AnyPref.getPrefs(prefKey).getInt(lengthKey, 0);
        ArrayList<String> keyList = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            keyList.add(PrefUtil.getArrayListItemKey(field, prefKey, i));
        }
        return keyList;
    }

    public static Class getArrayListType(Field field) {
        String mapKey = PrefUtil.getCacheKeyForField(field);
        Class result = arraylistType.get(mapKey);
        if (result == null) {
            ParameterizedType pt;
            Type[] types;
            Type tp;
            if (field.getType().isAssignableFrom(ArrayList.class) && (tp = field.getGenericType()) != null && tp instanceof ParameterizedType && (types = (pt = (ParameterizedType)tp).getActualTypeArguments()).length == 1) {
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                arraylistType.put(mapKey, genericClazz);
                return genericClazz;
            }
        } else {
            return result;
        }
        return null;
    }

    public static String getArrayListItemKey(Field field, String prefKey, int index) {
        return prefKey + "$$$$" + PrefUtil.getKeyForField(field) + "_arraylist_" + index;
    }

    public static String getArrayListLengthKey(Field field, String prefKey) {
        return prefKey + "$$$$" + PrefUtil.getKeyForField(field) + "_arraylist_length";
    }

    public static boolean isPrefSubNullable(Field field) {
        return field.getAnnotation(PrefSub.class).nullable();
    }

    public static int isPrefArrayListNullable(Field field) {
        PrefArrayList prefArrayList = field.getAnnotation(PrefArrayList.class);
        boolean arrayNullable = prefArrayList.nullable();
        boolean itemNullable = prefArrayList.itemNullable();
        return (arrayNullable ? 2 : 0) + (itemNullable ? 1 : 0);
    }
}

