/*
 * Decompiled with CFR 0.152.
 */
package net.nashlegend.anypref;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.nashlegend.anypref.SharedPrefs;
import net.nashlegend.anypref.annotations.PrefField;
import net.nashlegend.anypref.annotations.PrefIgnore;
import net.nashlegend.anypref.annotations.PrefModel;

public class AnyPref {
    private static Context mContext;
    private static ConcurrentHashMap<String, ArrayList<Field>> fieldsMap;
    private static ConcurrentHashMap<String, Boolean> strSetMap;
    private static ConcurrentHashMap<String, String> classKeyMap;
    private static ConcurrentHashMap<String, String> fieldKeyMap;
    private static ConcurrentHashMap<String, Double> defaultNumberMap;
    private static ConcurrentHashMap<String, Boolean> defaultBooleanMap;
    private static ConcurrentHashMap<String, String> defaultStringMap;
    private static ConcurrentHashMap<String, Set<String>> defaultStringSetMap;

    public static void init(Context context) {
        mContext = context;
    }

    public static SharedPrefs getPrefs(String key) {
        return new SharedPrefs(key, mContext);
    }

    public static SharedPrefs getPrefs(Class clazz) {
        return new SharedPrefs(AnyPref.getKeyForClazz(clazz), mContext);
    }

    public static void clear(Class clazz) {
        new SharedPrefs(AnyPref.getKeyForClazz(clazz), mContext).clear();
    }

    public static <T> T read(Class<T> clazz) {
        T obj;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        for (Field field : AnyPref.getFields(clazz)) {
            AnyPref.read(mContext.getSharedPreferences(AnyPref.getKeyForClazz(clazz), 0), field, obj);
        }
        return obj;
    }

    public static void save(Object object) {
        SharedPreferences.Editor editor = mContext.getSharedPreferences(AnyPref.getKeyForClazz(object.getClass()), 0).edit();
        for (Field field : AnyPref.getFields(object.getClass())) {
            AnyPref.put(editor, field, object);
        }
        editor.apply();
    }

    private static void put(SharedPreferences.Editor editor, Field field, Object object) {
        String key = AnyPref.getKeyForField(field);
        String type = field.getType().getCanonicalName();
        try {
            switch (type) {
                case "int": {
                    editor.putInt(key, field.getInt(object));
                    break;
                }
                case "float": {
                    editor.putFloat(key, field.getFloat(object));
                    break;
                }
                case "long": {
                    editor.putLong(key, field.getLong(object));
                    break;
                }
                case "boolean": {
                    editor.putBoolean(key, field.getBoolean(object));
                    break;
                }
                case "java.lang.String": {
                    editor.putString(key, String.valueOf(field.get(object)));
                    break;
                }
                default: {
                    String mapKey = AnyPref.getKeyForClazz(object.getClass()) + "$$" + key;
                    Boolean result = strSetMap.get(mapKey);
                    if (result == null) {
                        boolean isSet = AnyPref.isFieldStringSet(field);
                        if (isSet) {
                            editor.putStringSet(key, (Set)field.get(object));
                        }
                        strSetMap.put(mapKey, isSet);
                        break;
                    }
                    if (result.booleanValue()) {
                        editor.putStringSet(key, (Set)field.get(object));
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void read(SharedPreferences preferences, Field field, Object object) {
        String cacheKey = AnyPref.getCacheKeyForField(field);
        String key = AnyPref.getKeyForField(field);
        String type = field.getType().getCanonicalName();
        try {
            switch (type) {
                case "int": {
                    field.setInt(object, preferences.getInt(key, (int)AnyPref.getDefaultNumber(cacheKey)));
                    break;
                }
                case "float": {
                    field.setFloat(object, preferences.getFloat(key, (float)AnyPref.getDefaultNumber(cacheKey)));
                    break;
                }
                case "long": {
                    field.setLong(object, preferences.getLong(key, (long)AnyPref.getDefaultNumber(cacheKey)));
                    break;
                }
                case "boolean": {
                    field.setBoolean(object, preferences.getBoolean(key, AnyPref.getDefaultBoolean(cacheKey)));
                    break;
                }
                case "java.lang.String": {
                    field.set(object, preferences.getString(key, AnyPref.getDefaultString(cacheKey)));
                    break;
                }
                default: {
                    String mapKey = AnyPref.getKeyForClazz(object.getClass()) + "$$" + key;
                    Boolean result = strSetMap.get(mapKey);
                    if (result == null) {
                        boolean isSet = AnyPref.isFieldStringSet(field);
                        if (isSet) {
                            field.set(object, preferences.getStringSet(key, AnyPref.getDefaultStringSet(cacheKey)));
                        }
                        strSetMap.put(mapKey, isSet);
                        break;
                    }
                    if (result.booleanValue()) {
                        field.set(object, preferences.getStringSet(key, AnyPref.getDefaultStringSet(cacheKey)));
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static boolean isFieldStringSet(Field field) {
        Class genericClazz;
        ParameterizedType pt;
        Type[] types;
        Type tp;
        return field.getType().isAssignableFrom(Set.class) && (tp = field.getGenericType()) != null && tp instanceof ParameterizedType && (types = (pt = (ParameterizedType)tp).getActualTypeArguments()).length == 1 && (genericClazz = (Class)pt.getActualTypeArguments()[0]).getCanonicalName().equals(String.class.getCanonicalName());
    }

    private static String getKeyForClazz(Class clazz) {
        String key = classKeyMap.get(clazz.getCanonicalName());
        if (key == null) {
            PrefModel model;
            String value;
            if (clazz.isAnnotationPresent(PrefModel.class) && !TextUtils.isEmpty((CharSequence)(value = (model = clazz.getAnnotation(PrefModel.class)).value()))) {
                classKeyMap.put(clazz.getCanonicalName(), value);
                return value;
            }
            classKeyMap.put(clazz.getCanonicalName(), clazz.getCanonicalName());
            return clazz.getCanonicalName();
        }
        return key;
    }

    private static String getKeyForField(Field field) {
        String cacheKey = AnyPref.getCacheKeyForField(field);
        String key = fieldKeyMap.get(cacheKey);
        if (key == null) {
            PrefField pref;
            String value;
            if (field.isAnnotationPresent(PrefField.class) && !TextUtils.isEmpty((CharSequence)(value = (pref = field.getAnnotation(PrefField.class)).value()))) {
                fieldKeyMap.put(cacheKey, value);
                return value;
            }
            fieldKeyMap.put(cacheKey, field.getName());
            return field.getName();
        }
        return key;
    }

    private static boolean isFieldIgnored(Field field) {
        return field.isAnnotationPresent(PrefIgnore.class);
    }

    private static ArrayList<Field> getFields(Class clazz) {
        String key = AnyPref.getKeyForClazz(clazz);
        ArrayList<Field> fields = fieldsMap.get(key);
        if (fields == null) {
            Field[] fieldArray;
            fields = new ArrayList();
            for (Field field : fieldArray = clazz.getFields()) {
                int modifier = field.getModifiers();
                if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier) || AnyPref.isFieldIgnored(field)) continue;
                AnyPref.getDefaultValue(field);
                fields.add(field);
            }
            fieldsMap.put(key, fields);
        }
        return fields;
    }

    private static void getDefaultValue(Field field) {
        if (field.isAnnotationPresent(PrefField.class)) {
            String type;
            PrefField pref = field.getAnnotation(PrefField.class);
            String cacheKey = AnyPref.getCacheKeyForField(field);
            switch (type = field.getType().getCanonicalName()) {
                case "int": 
                case "float": 
                case "long": {
                    defaultNumberMap.put(cacheKey, pref.number());
                    break;
                }
                case "boolean": {
                    defaultBooleanMap.put(cacheKey, pref.bool());
                    break;
                }
                case "java.lang.String": {
                    String[] ds = pref.string();
                    if (ds == null || ds.length <= 0) break;
                    defaultStringMap.put(cacheKey, pref.string()[0]);
                    break;
                }
                default: {
                    String[] sets;
                    if (!AnyPref.isFieldStringSet(field) || (sets = pref.string()) == null) break;
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.addAll(Arrays.asList(pref.string()));
                    defaultStringSetMap.put(cacheKey, hashSet);
                }
            }
        }
    }

    private static String getCacheKeyForField(Field field) {
        return field.getDeclaringClass().getCanonicalName() + "$$" + field.getName();
    }

    private static double getDefaultNumber(String key) {
        Double num = defaultNumberMap.get(key);
        if (num == null) {
            return 0.0;
        }
        return num;
    }

    private static boolean getDefaultBoolean(String key) {
        Boolean bool = defaultBooleanMap.get(key);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private static String getDefaultString(String key) {
        return defaultStringMap.get(key);
    }

    private static Set<String> getDefaultStringSet(String key) {
        return defaultStringSetMap.get(key);
    }

    static {
        fieldsMap = new ConcurrentHashMap();
        strSetMap = new ConcurrentHashMap();
        classKeyMap = new ConcurrentHashMap();
        fieldKeyMap = new ConcurrentHashMap();
        defaultNumberMap = new ConcurrentHashMap();
        defaultBooleanMap = new ConcurrentHashMap();
        defaultStringMap = new ConcurrentHashMap();
        defaultStringSetMap = new ConcurrentHashMap();
    }
}

