/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.util.Debug;
import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import android.sun.security.util.ObjectIdentifier;
import android.sun.security.x509.AttributeNameEnumeration;
import android.sun.security.x509.CertAttrSet;
import android.sun.security.x509.Extension;
import android.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet<String> {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String IDENT = "x509.info.extensions.InhibitAnyPolicy";
    public static ObjectIdentifier AnyPolicy_Id;
    public static final String NAME = "InhibitAnyPolicy";
    public static final String SKIP_CERTS = "skip_certs";
    private int skipCerts = Integer.MAX_VALUE;

    private void encodeThis() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putInteger(this.skipCerts);
        this.extensionValue = out.toByteArray();
    }

    public InhibitAnyPolicyExtension(int skipCerts) throws IOException {
        if (skipCerts < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = skipCerts == -1 ? Integer.MAX_VALUE : skipCerts;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
    }

    public InhibitAnyPolicyExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        if (!critical.booleanValue()) {
            throw new IOException("Criticality cannot be false for InhibitAnyPolicy");
        }
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 2) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: data not integer");
        }
        if (val.data == null) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: null data");
        }
        int skipCertsValue = val.getInteger();
        if (skipCertsValue < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = skipCertsValue == -1 ? Integer.MAX_VALUE : skipCertsValue;
    }

    @Override
    public String toString() {
        String s = super.toString() + "InhibitAnyPolicy: " + this.skipCerts + "\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(SKIP_CERTS)) {
            if (!(obj instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            int skipCertsValue = (Integer)obj;
            if (skipCertsValue < -1) {
                throw new IOException("Invalid value for skipCerts");
            }
            this.skipCerts = skipCertsValue == -1 ? Integer.MAX_VALUE : skipCertsValue;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(SKIP_CERTS)) {
            return new Integer(this.skipCerts);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(SKIP_CERTS)) {
            throw new IOException("Attribute skip_certs may not be deleted.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(SKIP_CERTS);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            AnyPolicy_Id = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

