/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.util.DerInputStream;
import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import android.sun.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class CertificatePolicySet {
    private final Vector<CertificatePolicyId> ids;

    public CertificatePolicySet(Vector<CertificatePolicyId> ids) {
        this.ids = ids;
    }

    public CertificatePolicySet(DerInputStream in) throws IOException {
        this.ids = new Vector();
        DerValue[] seq = in.getSequence(5);
        for (int i = 0; i < seq.length; ++i) {
            CertificatePolicyId id = new CertificatePolicyId(seq[i]);
            this.ids.addElement(id);
        }
    }

    public String toString() {
        String s = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.ids.size(); ++i) {
            this.ids.elementAt(i).encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    public List<CertificatePolicyId> getCertPolicyIds() {
        return Collections.unmodifiableList(this.ids);
    }
}

