/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.crypto.spake2;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.github.muntashirakon.crypto.spake2.Spake2Role;
import javax.security.auth.Destroyable;

public class Spake2Context
implements Destroyable {
    public static final int MAX_MSG_SIZE = 32;
    public static final int MAX_KEY_SIZE = 64;
    private final long mCtx;
    private final byte[] mMyMsg = new byte[32];
    private boolean mDisablePasswordScalarHack;
    private boolean mIsDestroyed;

    public Spake2Context(@NonNull Spake2Role myRole, byte[] myName, byte[] theirName) {
        this.mCtx = Spake2Context.allocNewContext(myRole.ordinal(), myName, theirName);
        if (this.mCtx == 0L) {
            throw new UnsupportedOperationException("Could not allocate native context");
        }
    }

    @NonNull
    public byte[] getMyMsg() {
        return this.mMyMsg;
    }

    public boolean isDisablePasswordScalarHack() {
        return this.mDisablePasswordScalarHack;
    }

    public void setDisablePasswordScalarHack(boolean disablePasswordScalarHack) {
        this.mDisablePasswordScalarHack = disablePasswordScalarHack;
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public byte[] generateMessage(byte[] password) throws IllegalStateException {
        if (this.mIsDestroyed) {
            throw new IllegalStateException("The context was destroyed.");
        }
        byte[] myMsg = Spake2Context.generateMessage(this.mCtx, password);
        if (myMsg == null) {
            throw new IllegalStateException("Generated empty message");
        }
        System.arraycopy(myMsg, 0, this.mMyMsg, 0, 32);
        return myMsg;
    }

    public byte[] processMessage(byte[] theirMessage) throws IllegalStateException {
        if (this.mIsDestroyed) {
            throw new IllegalStateException("The context was destroyed.");
        }
        byte[] key = Spake2Context.processMessage(this.mCtx, theirMessage);
        if (key == null) {
            throw new IllegalStateException("No key was returned");
        }
        return key;
    }

    @Override
    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    @Override
    public void destroy() {
        this.mIsDestroyed = true;
        Spake2Context.destroy(this.mCtx);
    }

    private static native long allocNewContext(int var0, byte[] var1, byte[] var2);

    @Nullable
    private static native byte[] generateMessage(long var0, byte[] var2);

    @Nullable
    private static native byte[] processMessage(long var0, byte[] var2);

    private static native void destroy(long var0);

    static {
        System.loadLibrary("spake2");
    }
}

