/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class LocalServices {
    static final int SERVICE_FIRST = 1;
    public static final int SHELL = 1;
    public static final int REMOUNT = 2;
    public static final int FILE = 3;
    public static final int TCP_CONNECT = 4;
    public static final int LOCAL_UNIX_SOCKET = 5;
    public static final int LOCAL_UNIX_SOCKET_RESERVED = 6;
    public static final int LOCAL_UNIX_SOCKET_ABSTRACT = 7;
    public static final int LOCAL_UNIX_SOCKET_FILE_SYSTEM = 8;
    public static final int FRAMEBUFFER = 9;
    public static final int CONNECT_JDWP = 10;
    public static final int TRACK_JDWP = 11;
    public static final int SYNC = 12;
    public static final int REVERSE = 13;
    public static final int BACKUP = 14;
    public static final int RESTORE = 15;
    static final int SERVICE_LAST = 15;

    @NonNull
    static String getServiceName(int service) {
        switch (service) {
            case 1: {
                return "shell:";
            }
            case 10: {
                return "jdwp:";
            }
            case 3: {
                return "dev:";
            }
            case 9: {
                return "framebuffer:";
            }
            case 5: {
                return "local:";
            }
            case 7: {
                return "localabstract:";
            }
            case 8: {
                return "localfilesystem:";
            }
            case 6: {
                return "localreserved:";
            }
            case 2: {
                return "remount:";
            }
            case 13: {
                return "reverse:";
            }
            case 12: {
                return "sync:";
            }
            case 4: {
                return "tcp:";
            }
            case 11: {
                return "track-jdwp";
            }
            case 14: {
                return "backup:";
            }
            case 15: {
                return "restore:";
            }
        }
        throw new IllegalArgumentException("Invalid service: " + service);
    }

    @NonNull
    static String getDestination(int service, String ... args) {
        String serviceName = LocalServices.getServiceName(service);
        StringBuilder destination = new StringBuilder(serviceName);
        switch (service) {
            case 1: {
                for (String arg : args) {
                    if (arg.contains("\"")) {
                        throw new IllegalArgumentException("Arguments for inline shell cannot contain double quotations.");
                    }
                    if (arg.contains(" ")) {
                        destination.append("\"").append(Objects.requireNonNull(arg)).append("\"");
                        continue;
                    }
                    destination.append(Objects.requireNonNull(arg));
                }
                break;
            }
            case 3: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("File name must be specified.");
                }
                if (args.length != 1) {
                    throw new IllegalArgumentException("Service expects exactly one argument, " + args.length + " supplied.");
                }
                destination.append(Objects.requireNonNull(args[0]));
                break;
            }
            case 4: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Port number must be specified.");
                }
                if (args.length == 1) {
                    destination.append(args[0]);
                    break;
                }
                if (args.length == 2) {
                    destination.append(Objects.requireNonNull(args[0])).append(':').append(Objects.requireNonNull(args[1]));
                    break;
                }
                throw new IllegalArgumentException("Invalid number of arguments supplied.");
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Path must be specified.");
                }
                if (args.length != 1) {
                    throw new IllegalArgumentException("Service expects exactly one argument, " + args.length + " supplied.");
                }
                destination.append(Objects.requireNonNull(args[0]));
                break;
            }
            case 10: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("PID must be specified.");
                }
                if (args.length != 1) {
                    throw new IllegalArgumentException("Service expects exactly one argument, " + args.length + " supplied.");
                }
                destination.append(Objects.requireNonNull(args[0]));
                break;
            }
            case 13: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Forward command must be specified.");
                }
                if (args.length != 1) {
                    throw new IllegalArgumentException("Service expects exactly one argument, " + args.length + " supplied.");
                }
                if (args[0] == null) {
                    throw new IllegalArgumentException("Forward command is empty");
                }
                if ("list-forward".equals(args[0]) || "killforward-all".equals(args[0])) {
                    destination.append(args[0]);
                    break;
                }
                if (args[0].startsWith("forward:") || args[0].startsWith("killforward:")) {
                    destination.append(args[0]);
                    break;
                }
                throw new IllegalArgumentException("Invalid forward command.");
            }
            case 14: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("At least one package must be specified or use -shared/-all.");
                }
            }
            case 2: {
                destination.append(TextUtils.join((CharSequence)" ", (Object[])args));
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                if (args.length == 0) break;
                throw new IllegalArgumentException("Service expects no arguments.");
            }
        }
        return destination.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Services {
    }
}

