/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import io.github.muntashirakon.adb.AdbConnection;
import io.github.muntashirakon.adb.AdbStream;
import io.github.muntashirakon.adb.KeyPair;
import io.github.muntashirakon.adb.PairingConnectionCtx;
import io.github.muntashirakon.adb.StringCompat;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.security.auth.DestroyFailedException;

public abstract class AbsAdbConnectionManager
implements Closeable {
    private final Object mLock = new Object();
    @Nullable
    private AdbConnection mAdbConnection;
    private String mHostAddress;
    private String mOldHostAddress = this.mHostAddress = "127.0.0.1";
    private int mApi = 1;
    private long mTimeout = Long.MAX_VALUE;
    private TimeUnit mTimeoutUnit = TimeUnit.MILLISECONDS;
    private boolean mThrowOnUnauthorised = false;

    @NonNull
    protected abstract PrivateKey getPrivateKey();

    @NonNull
    protected abstract Certificate getCertificate();

    @NonNull
    protected abstract String getDeviceName();

    @CallSuper
    public void setHostAddress(@NonNull String hostAddress) {
        this.mOldHostAddress = this.mHostAddress;
        this.mHostAddress = Objects.requireNonNull(hostAddress);
    }

    @NonNull
    public String getHostAddress() {
        return this.mHostAddress;
    }

    public void setApi(int api) {
        this.mApi = api;
    }

    public int getApi() {
        return this.mApi;
    }

    @CallSuper
    public void setTimeout(long timeout, TimeUnit unit) {
        this.mTimeout = timeout;
        this.mTimeoutUnit = unit;
    }

    public long getTimeout() {
        return this.mTimeoutUnit.toMillis(this.mTimeout);
    }

    @NonNull
    public TimeUnit getTimeoutUnit() {
        return this.mTimeoutUnit;
    }

    @CallSuper
    public void setThrowOnUnauthorised(boolean throwOnUnauthorised) {
        this.mThrowOnUnauthorised = throwOnUnauthorised;
    }

    public boolean isThrowOnUnauthorised() {
        return this.mThrowOnUnauthorised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    @Nullable
    public AdbConnection getAdbConnection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAdbConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAdbConnection != null && this.mAdbConnection.isConnected() && this.mAdbConnection.isConnectionEstablished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean connect(int port) throws IOException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.needNoNewConnection(this.mHostAddress)) {
                return false;
            }
            this.mAdbConnection = new AdbConnection.Builder(this.mHostAddress, port).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean connect(@NonNull String host, int port) throws IOException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            this.mOldHostAddress = this.mHostAddress;
            if (this.needNoNewConnection(Objects.requireNonNull(host))) {
                return false;
            }
            this.mAdbConnection = new AdbConnection.Builder(host, port).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection != null) {
                this.mAdbConnection.close();
                this.mAdbConnection = null;
            }
        }
    }

    @WorkerThread
    @NonNull
    public AdbStream openStream(String destination) throws IOException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection != null && this.mAdbConnection.isConnected()) {
                return this.mAdbConnection.open(destination);
            }
            throw new IOException("Not connected to ADB.");
        }
    }

    @WorkerThread
    @RequiresApi(value=9)
    public boolean pair(int port, @NonNull String pairingCode) throws Exception {
        return this.pair(this.mHostAddress, port, pairingCode);
    }

    @WorkerThread
    @RequiresApi(value=9)
    public boolean pair(@NonNull String host, int port, @NonNull String pairingCode) throws Exception {
        KeyPair keyPair = this.getAdbKeyPair();
        try (PairingConnectionCtx pairingClient = new PairingConnectionCtx(Objects.requireNonNull(host), port, StringCompat.getBytes(Objects.requireNonNull(pairingCode), "UTF-8"), keyPair, this.getDeviceName());){
            pairingClient.start();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            this.getPrivateKey().destroy();
        }
        catch (NoSuchMethodError | DestroyFailedException e) {
            e.printStackTrace();
        }
        if (this.mAdbConnection != null) {
            this.mAdbConnection.close();
            this.mAdbConnection = null;
        }
    }

    @NonNull
    private KeyPair getAdbKeyPair() {
        return new KeyPair(Objects.requireNonNull(this.getPrivateKey()), Objects.requireNonNull(this.getCertificate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needNoNewConnection(@NonNull String newHostAddress) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection == null) {
                return false;
            }
            if (this.mAdbConnection.isConnected()) {
                return true;
            }
            return newHostAddress.equals(this.mOldHostAddress);
        }
    }
}

