/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.merseyside.utils.ext.NumberExtKt;
import com.merseyside.utils.layout.LinearLayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\rH\u0016J4\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J,\u0010%\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\rH\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/merseyside/utils/layout/WrapContentLinearLayoutManager;", "Lcom/merseyside/utils/layout/LinearLayoutManager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "desiredItemSize", "orientation", "reverseLayout", "", "(Landroid/content/Context;IIZ)V", "measuredHeight", "getMeasuredHeight", "()I", "setMeasuredHeight", "(I)V", "measuredWidth", "getMeasuredWidth", "setMeasuredWidth", "isAutoMeasureEnabled", "measureScrapChild", "", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "Landroidx/recyclerview/widget/RecyclerView;", "position", "widthSpec", "heightSpec", "measuredDimension", "", "onLayoutChildren", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onMeasure", "supportsPredictiveItemAnimations", "utils_release"})
public class WrapContentLinearLayoutManager
extends LinearLayoutManager {
    private int measuredWidth;
    private int measuredHeight;
    private int desiredItemSize;

    public WrapContentLinearLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public final int getMeasuredWidth() {
        return this.measuredWidth;
    }

    public final void setMeasuredWidth(int n) {
        this.measuredWidth = n;
    }

    public final int getMeasuredHeight() {
        return this.measuredHeight;
    }

    public final void setMeasuredHeight(int n) {
        this.measuredHeight = n;
    }

    public WrapContentLinearLayoutManager(@NotNull Context context, int desiredItemSize, int orientation, boolean reverseLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, orientation, reverseLayout);
        this.desiredItemSize = desiredItemSize;
    }

    @Override
    public void onLayoutChildren(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        try {
            super.onLayoutChildren(recycler, state);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void onMeasure(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state, int widthSpec, int heightSpec) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        int calculatedWidth = 0;
        int calculatedHeight = 0;
        int desiredSize = 0;
        int[] intArray = new int[2];
        int n3 = 0;
        int n4 = this.getItemCount();
        while (n3 < n4) {
            int i = n3++;
            desiredSize += this.desiredItemSize;
            try {
                this.measureScrapChild(recycler, i, View.MeasureSpec.makeMeasureSpec((int)i, (int)0), View.MeasureSpec.makeMeasureSpec((int)i, (int)0), intArray);
                if (this.getOrientation() == 0) {
                    calculatedWidth += intArray[0];
                    if (i != 0) continue;
                    calculatedHeight = intArray[1];
                    continue;
                }
                calculatedHeight += intArray[1];
                if (i != 0) continue;
                calculatedWidth = intArray[0];
            }
            catch (IndexOutOfBoundsException e) {
                super.onMeasure(recycler, state, widthSpec, heightSpec);
                return;
            }
        }
        switch (widthMode) {
            case 0x40000000: {
                if (NumberExtKt.isNotZero(calculatedWidth) && this.getOrientation() == 0) {
                    if (widthSize < desiredSize) {
                        n2 = Math.min(calculatedWidth, widthSize);
                        break;
                    }
                    n2 = desiredSize;
                    break;
                }
                n2 = widthSize;
                break;
            }
            case -2147483648: 
            case 0: {
                n4 = this.getWidth();
                n2 = Math.min(calculatedWidth, n4);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        this.measuredWidth = n2;
        switch (heightMode) {
            case 0x40000000: {
                if (NumberExtKt.isNotZero(calculatedHeight) && this.getOrientation() == 1) {
                    if (heightSize < desiredSize) {
                        n = Math.min(calculatedHeight, heightSize);
                        break;
                    }
                    n = desiredSize;
                    break;
                }
                n = heightSize;
                break;
            }
            case -2147483648: 
            case 0: {
                n4 = this.getHeight();
                n = Math.min(calculatedHeight, n4);
                break;
            }
            default: {
                n = 0;
            }
        }
        this.measuredHeight = n;
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean isAutoMeasureEnabled() {
        return false;
    }

    private final void measureScrapChild(RecyclerView.Recycler recycler, int position, int widthSpec, int heightSpec, int[] measuredDimension) throws IndexOutOfBoundsException {
        View view = recycler.getViewForPosition(position);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"recycler.getViewForPosition(position)");
        View view2 = view;
        ViewGroup.LayoutParams p = view2.getLayoutParams();
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)p.width);
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)p.height);
        view2.measure(childWidthSpec, childHeightSpec);
        measuredDimension[0] = view2.getMeasuredWidth();
        measuredDimension[1] = view2.getMeasuredHeight();
        recycler.recycleView(view2);
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return false;
    }
}

