/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import com.merseyside.merseyLib.time.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0004\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/merseyside/utils/billing/Period;", "", "()V", "count", "", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "getHumanReadablePeriod", "toTimeUnit", "Lcom/merseyside/merseyLib/time/TimeUnit;", "Companion", "Days", "FourWeeks", "FourteenDays", "Month", "OneMonth", "OneWeek", "OneYear", "SixMonth", "ThreeDays", "ThreeMonth", "Weeks", "Years", "Lcom/merseyside/utils/billing/Period$Days;", "Lcom/merseyside/utils/billing/Period$Weeks;", "Lcom/merseyside/utils/billing/Period$Month;", "Lcom/merseyside/utils/billing/Period$Years;", "utils_release"})
public abstract class Period {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Period() {
    }

    public abstract int getCount();

    @NotNull
    public abstract String getUnit();

    @NotNull
    public final String getHumanReadablePeriod() {
        return "" + this.getCount() + ' ' + this.getUnit();
    }

    @NotNull
    public abstract TimeUnit toTimeUnit();

    public /* synthetic */ Period(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Days;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/merseyLib/time/TimeUnit;", "utils_release"})
    public static abstract class Days
    extends Period {
        private final int count;

        public Days(int count) {
            super(null);
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        @NotNull
        public String getUnit() {
            String str = "Day";
            if (this.getCount() > 1) {
                str = Intrinsics.stringPlus((String)str, (Object)"s");
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return (TimeUnit)new com.merseyside.merseyLib.time.Days((Number)this.getCount());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Weeks;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/merseyLib/time/TimeUnit;", "utils_release"})
    public static abstract class Weeks
    extends Period {
        private final int count;

        public Weeks(int count) {
            super(null);
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        @NotNull
        public String getUnit() {
            String str = "Week";
            if (this.getCount() > 1) {
                str = Intrinsics.stringPlus((String)str, (Object)"s");
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return (TimeUnit)new com.merseyside.merseyLib.time.Days((Number)(this.getCount() * 7));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Month;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/merseyLib/time/TimeUnit;", "utils_release"})
    public static abstract class Month
    extends Period {
        private final int count;

        public Month(int count) {
            super(null);
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        @NotNull
        public String getUnit() {
            return "Month";
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return (TimeUnit)new com.merseyside.merseyLib.time.Days((Number)(this.getCount() * 30));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Years;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/merseyLib/time/TimeUnit;", "utils_release"})
    public static abstract class Years
    extends Period {
        private final int count;

        public Years(int count) {
            super(null);
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        @NotNull
        public String getUnit() {
            String str = "Year";
            if (this.getCount() > 1) {
                str = Intrinsics.stringPlus((String)str, (Object)"s");
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return (TimeUnit)new com.merseyside.merseyLib.time.Days((Number)(this.getCount() * 365));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$ThreeDays;", "Lcom/merseyside/utils/billing/Period$Days;", "()V", "utils_release"})
    public static final class ThreeDays
    extends Days {
        @NotNull
        public static final ThreeDays INSTANCE = new ThreeDays();

        private ThreeDays() {
            super(3);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneWeek;", "Lcom/merseyside/utils/billing/Period$Weeks;", "()V", "utils_release"})
    public static final class OneWeek
    extends Weeks {
        @NotNull
        public static final OneWeek INSTANCE = new OneWeek();

        private OneWeek() {
            super(1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$FourteenDays;", "Lcom/merseyside/utils/billing/Period$Days;", "()V", "utils_release"})
    public static final class FourteenDays
    extends Days {
        @NotNull
        public static final FourteenDays INSTANCE = new FourteenDays();

        private FourteenDays() {
            super(14);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$FourWeeks;", "Lcom/merseyside/utils/billing/Period$Weeks;", "()V", "utils_release"})
    public static final class FourWeeks
    extends Weeks {
        @NotNull
        public static final FourWeeks INSTANCE = new FourWeeks();

        private FourWeeks() {
            super(4);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class OneMonth
    extends Month {
        @NotNull
        public static final OneMonth INSTANCE = new OneMonth();

        private OneMonth() {
            super(1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$ThreeMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class ThreeMonth
    extends Month {
        @NotNull
        public static final ThreeMonth INSTANCE = new ThreeMonth();

        private ThreeMonth() {
            super(3);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$SixMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class SixMonth
    extends Month {
        @NotNull
        public static final SixMonth INSTANCE = new SixMonth();

        private SixMonth() {
            super(6);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneYear;", "Lcom/merseyside/utils/billing/Period$Years;", "()V", "utils_release"})
    public static final class OneYear
    extends Years {
        @NotNull
        public static final OneYear INSTANCE = new OneYear();

        private OneYear() {
            super(1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/billing/Period$Companion;", "", "()V", "stringToPeriod", "Lcom/merseyside/utils/billing/Period;", "period", "", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Period stringToPeriod(@NotNull String period) {
            Period period2;
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            switch (period) {
                case "P3D": {
                    period2 = ThreeDays.INSTANCE;
                    break;
                }
                case "P1W": {
                    period2 = OneWeek.INSTANCE;
                    break;
                }
                case "P14D": {
                    period2 = FourteenDays.INSTANCE;
                    break;
                }
                case "P4W": {
                    period2 = FourWeeks.INSTANCE;
                    break;
                }
                case "P1M": {
                    period2 = OneMonth.INSTANCE;
                    break;
                }
                case "P3M": {
                    period2 = ThreeMonth.INSTANCE;
                    break;
                }
                case "P6M": {
                    period2 = SixMonth.INSTANCE;
                    break;
                }
                case "P1Y": {
                    period2 = OneYear.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return period2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

