/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.content.Context;
import android.graphics.Color;
import android.os.Environment;
import androidx.annotation.ColorInt;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a1\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u00102\u0006\u0010\u0013\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0014\u001a\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0004\u001a\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0011\u00a8\u0006\u001b"}, d2={"adjustAlpha", "", "color", "factor", "", "convertDpToPixel", "context", "Landroid/content/Context;", "dp", "convertPixelsToDp", "px", "generateRandomString", "", "length", "getMinMax", "Lkotlin/Pair;", "T", "", "first", "second", "(Ljava/lang/Number;Ljava/lang/Number;)Lkotlin/Pair;", "isExternalStorageReadable", "", "randomBool", "positiveProbability", "shrinkNumber", "number", "utils_release"})
@JvmName(name="LibUtils")
public final class LibUtils {
    public static final boolean randomBool(float positiveProbability) {
        java.util.Random rand;
        return positiveProbability >= 1.0f ? true : (positiveProbability <= 0.0f ? false : (rand = new java.util.Random()).nextFloat() <= positiveProbability);
    }

    public static /* synthetic */ boolean randomBool$default(float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        return LibUtils.randomBool(f);
    }

    public static final float convertPixelsToDp(@NotNull Context context, int px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float density = context.getResources().getDisplayMetrics().density;
        return (float)px / density;
    }

    public static final int convertDpToPixel(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dp * density);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateRandomString(int length) {
        if (length > 0) {
            Constable constable;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            List charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
            Iterable $this$map$iv = (Iterable)new IntRange(1, length);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                constable = Random.Default.nextInt(0, charPool.size());
                collection.add(constable);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                int it = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                constable = Character.valueOf(((Character)charPool.get((int)p0)).charValue());
                collection.add(constable);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    public static final boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return Intrinsics.areEqual((Object)"mounted", (Object)state) || Intrinsics.areEqual((Object)"mounted_ro", (Object)state);
    }

    @NotNull
    public static final String shrinkNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        long l = number.longValue();
        return l < 1000L ? String.valueOf(l) : (l < 1000000L ? l / (long)1000 + "K+" : l / (long)1000000 + "M+");
    }

    @ColorInt
    public static final int adjustAlpha(@ColorInt int color2, float factor) {
        int alpha = MathKt.roundToInt((float)((float)Color.alpha((int)color2) * factor));
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @NotNull
    public static final <T extends Number> Pair<T, T> getMinMax(@NotNull T first, @NotNull T second) {
        Intrinsics.checkNotNullParameter(first, (String)"first");
        Intrinsics.checkNotNullParameter(second, (String)"second");
        int n = first.intValue();
        int n2 = second.intValue();
        int n3 = 0;
        int min = Math.min(n, n2);
        n2 = first.intValue();
        n3 = second.intValue();
        boolean bl = false;
        int max = Math.max(n2, n3);
        return TuplesKt.to((Object)min, (Object)max);
    }
}

