/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.layout;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.merseyside.utils.layout.SizeProviderLayoutManager;
import com.merseyside.utils.layout.WrapContentLinearLayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB9\b\u0016\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010#\u001a\u00020\u000eH\u0002R\u001a\u0010\u0011\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/merseyside/utils/layout/LinearAutofitLayoutManager;", "Lcom/merseyside/utils/layout/WrapContentLinearLayoutManager;", "Lcom/merseyside/utils/layout/SizeProviderLayoutManager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "desiredItemSize", "orientation", "reverseLayout", "", "maxSize", "(Landroid/content/Context;IIZI)V", "itemHeight", "getItemHeight", "()I", "setItemHeight", "(I)V", "itemWidth", "getItemWidth", "setItemWidth", "lastHeight", "lastItemCount", "lastWidth", "calculateItemSizes", "", "checkLayoutParams", "lp", "Landroidx/recyclerview/widget/RecyclerView$LayoutParams;", "resetMaxSize", "setMaxSize", "setupNewValues", "utils_release"})
public final class LinearAutofitLayoutManager
extends WrapContentLinearLayoutManager
implements SizeProviderLayoutManager {
    private int itemWidth;
    private int itemHeight;
    private int lastWidth;
    private int lastHeight;
    private int maxSize;
    private int lastItemCount;

    @Override
    public int getItemWidth() {
        return this.itemWidth;
    }

    @Override
    public void setItemWidth(int n) {
        this.itemWidth = n;
    }

    @Override
    public int getItemHeight() {
        return this.itemHeight;
    }

    @Override
    public void setItemHeight(int n) {
        this.itemHeight = n;
    }

    public LinearAutofitLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.maxSize = Integer.MAX_VALUE;
    }

    public LinearAutofitLayoutManager(@NonNull @NotNull Context context, int desiredItemSize, int orientation, boolean reverseLayout, int maxSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, desiredItemSize, orientation, reverseLayout);
        this.maxSize = Integer.MAX_VALUE;
        this.maxSize = maxSize;
    }

    public /* synthetic */ LinearAutofitLayoutManager(Context context, int n, int n2, boolean bl, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            bl = false;
        }
        if ((n4 & 0x10) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        this(context, n, n2, bl, n3);
    }

    public final void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public final void resetMaxSize() {
        this.maxSize = Integer.MAX_VALUE;
    }

    private final void calculateItemSizes() {
        if (this.lastItemCount != 0) {
            if (this.getOrientation() == 0) {
                int n = (this.lastWidth - this.getPaddingStart() - this.getPaddingEnd()) / this.lastItemCount;
                int n2 = this.maxSize;
                boolean bl = false;
                this.setItemWidth(Math.min(n, n2));
                this.setItemHeight(this.lastHeight - this.getPaddingTop() - this.getPaddingBottom());
            } else {
                this.setItemWidth(this.lastWidth - this.getPaddingStart() - this.getPaddingEnd());
                int n = (this.lastHeight - this.getPaddingTop() - this.getPaddingBottom()) / this.lastItemCount;
                int n3 = this.maxSize;
                boolean bl = false;
                this.setItemHeight(Math.min(n, n3));
            }
        }
    }

    private final boolean setupNewValues() {
        boolean bl;
        if (this.lastWidth != this.getMeasuredWidth() || this.lastHeight != this.getMeasuredHeight() || this.lastItemCount != this.getItemCount()) {
            this.lastWidth = this.getMeasuredWidth();
            this.lastHeight = this.getMeasuredHeight();
            this.lastItemCount = this.getItemCount();
            this.calculateItemSizes();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean checkLayoutParams(@NotNull RecyclerView.LayoutParams lp) {
        Intrinsics.checkNotNullParameter((Object)lp, (String)"lp");
        this.setupNewValues();
        lp.width = this.getItemWidth();
        lp.height = this.getItemHeight();
        return true;
    }
}

