/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.binding;

import android.content.Context;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.databinding.BindingAdapter;
import androidx.databinding.InverseBindingAdapter;
import androidx.databinding.InverseBindingListener;
import com.merseyside.utils.ext.ViewExtKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0007\u001a!\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u001a\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u001a\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007\u001a!\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u001a\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u00a8\u0006\u0017"}, d2={"getText", "", "textView", "Landroid/widget/TextView;", "setCount", "", "view", "collection", "", "setCustomTextColor", "attrId", "", "(Landroid/widget/TextView;Ljava/lang/Integer;)V", "setSpannedText", "charSequence", "", "setText", "text", "setTextColor", "colorRes", "setTextListener", "listener", "Landroidx/databinding/InverseBindingListener;", "utils_release"})
public final class TextBindingKt {
    @BindingAdapter(value={"app:text"})
    public static final void setText(@NotNull TextView textView, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (textView instanceof EditText) {
            ViewExtKt.setTextWithCursor((EditText)textView, text);
        } else {
            textView.setText((CharSequence)text);
        }
    }

    @BindingAdapter(value={"app:textAttrChanged"})
    public static final void setTextListener(@NotNull TextView textView, @Nullable InverseBindingListener listener) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        ViewExtKt.addTextChangeListener(textView, (Function7<? super TextView, ? super String, ? super String, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Boolean>)((Function7)new Function7<TextView, String, String, Integer, Integer, Integer, Integer, Boolean>(listener){
            final /* synthetic */ InverseBindingListener $listener;
            {
                this.$listener = $listener;
                super(7);
            }

            @NotNull
            public final Boolean invoke(@NotNull TextView $noName_0, @Nullable String $noName_1, @Nullable String $noName_2, int $noName_3, int $noName_4, int $noName_5, int $noName_6) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                InverseBindingListener inverseBindingListener = this.$listener;
                if (inverseBindingListener != null) {
                    inverseBindingListener.onChange();
                }
                return true;
            }
        }));
    }

    @InverseBindingAdapter(attribute="app:text")
    @NotNull
    public static final String getText(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        return ((Object)textView.getText()).toString();
    }

    @BindingAdapter(value={"app:resTextColor"})
    public static final void setTextColor(@NotNull TextView view, @ColorRes @Nullable Integer colorRes) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (colorRes != null) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorRes));
        }
    }

    @BindingAdapter(value={"app:attrTextColor"})
    public static final void setCustomTextColor(@NotNull TextView view, @AttrRes @Nullable Integer attrId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (attrId != null) {
            view.setTextColor(ViewExtKt.getColorFromAttr$default((View)view, attrId, null, false, 6, null));
        }
    }

    @BindingAdapter(value={"app:spanned"})
    public static final void setSpannedText(@NotNull TextView view, @Nullable CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (charSequence != null) {
            view.setText(charSequence);
        }
    }

    @BindingAdapter(value={"app:count"})
    public static final void setCount(@NotNull TextView view, @Nullable Collection<?> collection) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (collection != null) {
            view.setText((CharSequence)String.valueOf(collection.size()));
        } else {
            view.setText((CharSequence)"0");
        }
    }
}

